/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.variant;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.CompletionWizardPage;
import com.jidesoft.wizard.DefaultWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientNetworkUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.util.ProjectWorker;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.ProgressStatus;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.VariantTag;
import org.ut.biolab.medsavant.shared.serverapi.VariantManagerAdapter;
import org.ut.biolab.medsavant.shared.util.ExtensionsFileFilter;

public class ImportVariantsWizardWithAnnotation
extends WizardDialog {
    private static final Log LOG = LogFactory.getLog(ImportVariantsWizardWithAnnotation.class);
    private static VariantManagerAdapter manager = MedSavantClient.VariantManager;
    private List<VariantTag> variantTags;
    private File[] variantFiles;
    private boolean includeHomoRef = false;
    private JComboBox locationField;
    private boolean uploadRequired;
    private JPanel chooseContainer;
    private JLabel chooseTitleLabel;
    private JPanel filesOnMyComputerPanel;
    private JPanel filesOnMedSavantServerPanel;
    private JTextField serverPathField;
    private JTextField emailField;
    private JCheckBox autoPublish;
    private static final String NOTIFICATION_TITLE = "Importing Variants";
    private boolean useJannovar = true;
    private boolean doPhasing = true;
    private static final Dimension LOCATION_SIZE = new Dimension(150, 22);

    public ImportVariantsWizardWithAnnotation() {
        this.setTitle("Import Variants Wizard");
        WizardStyle.setStyle((int)3);
        this.variantTags = new ArrayList<VariantTag>();
        PageList model = new PageList();
        model.append((AbstractDialogPage)this.getWelcomePage());
        model.append((AbstractDialogPage)this.getVCFSourcePage());
        model.append((AbstractDialogPage)this.getChooseFilesPage());
        model.append((AbstractDialogPage)this.getAddTagsPage());
        model.append((AbstractDialogPage)this.getNotificationsPage());
        model.append((AbstractDialogPage)this.getQueuePage());
        model.append((AbstractDialogPage)this.getCompletePage());
        this.setPageList(model);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    public Dimension getPreferredSize() {
        return new Dimension(720, 600);
    }

    private void setUploadRequired(boolean req) {
        this.uploadRequired = req;
        if (this.chooseContainer != null) {
            this.chooseContainer.removeAll();
            if (this.uploadRequired) {
                this.chooseTitleLabel.setText("Choose the variant file(s) to be imported:");
                this.chooseContainer.add((Component)this.filesOnMyComputerPanel, "Center");
            } else {
                this.chooseTitleLabel.setText("Specify the full directory path containing variant file(s) to be imported:");
                this.chooseContainer.add((Component)this.filesOnMedSavantServerPanel, "Center");
            }
        }
    }

    private AbstractWizardPage getVCFSourcePage() {
        return new DefaultWizardPage("Location of Files"){
            private JRadioButton onMyComputerButton;
            private JRadioButton onMedSavantServerButton;
            {
                this.onMyComputerButton = new JRadioButton("This computer");
                this.onMedSavantServerButton = new JRadioButton("The MedSavant server");
                ButtonGroup g = new ButtonGroup();
                g.add(this.onMyComputerButton);
                g.add(this.onMedSavantServerButton);
                this.onMyComputerButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ImportVariantsWizardWithAnnotation.this.setUploadRequired(onMyComputerButton.isSelected());
                    }
                });
                this.onMedSavantServerButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ImportVariantsWizardWithAnnotation.this.setUploadRequired(onMyComputerButton.isSelected());
                    }
                });
                this.addText("The VCFs I want to import are on:");
                this.addComponent(this.onMyComputerButton);
                this.addComponent(this.onMedSavantServerButton);
                this.onMyComputerButton.setSelected(true);
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
    }

    private AbstractWizardPage getWelcomePage() {
        DefaultWizardPage page = new DefaultWizardPage("Import Variants"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        String projectName = ProjectController.getInstance().getCurrentProjectName();
        String referenceName = ReferenceController.getInstance().getCurrentReferenceName();
        page.addText("This wizard will help you import variants for:");
        JLabel nameLabel = new JLabel(projectName + " (" + referenceName + ")");
        nameLabel.setFont(ViewUtil.getMediumTitleFont());
        page.addComponent((JComponent)nameLabel);
        page.addText("If the variants are with respect to another reference\ngenome, switch to that reference and try importing again.");
        return page;
    }

    private AbstractWizardPage getChooseFilesPage() {
        DefaultWizardPage page = new DefaultWizardPage("Choose Files"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                if (ImportVariantsWizardWithAnnotation.this.uploadRequired) {
                    if (ImportVariantsWizardWithAnnotation.this.variantFiles != null && ImportVariantsWizardWithAnnotation.this.variantFiles.length > 0) {
                        this.fireButtonEvent(3301, "NEXT");
                    } else {
                        this.fireButtonEvent(3302, "NEXT");
                    }
                } else if (ImportVariantsWizardWithAnnotation.this.serverPathField.getText().isEmpty()) {
                    this.fireButtonEvent(3302, "NEXT");
                } else {
                    this.fireButtonEvent(3301, "NEXT");
                }
            }
        };
        this.chooseContainer = new JPanel();
        this.chooseContainer = new JPanel();
        this.chooseContainer.setLayout(new BorderLayout());
        this.chooseTitleLabel = new JLabel();
        this.filesOnMyComputerPanel = this.populateOnMyComputerPanel(page);
        this.filesOnMedSavantServerPanel = this.populateOnServerPanel(page);
        page.addComponent((JComponent)this.chooseTitleLabel);
        page.addComponent((JComponent)this.chooseContainer);
        page.addText("Files must be in Variant Call Format v4.1 (*.vcf) or BGZipped\nVCF (*.vcf.gz).");
        page.addComponent(ViewUtil.horizontallyAlignComponents(new Component[]{new JLabel("More VCF file restrictions"), ViewUtil.getHelpButton("Variant File Format", "Files must be in Variant Call Format v4.1 (*.vcf) or BGZipped\nVCF (*.vcf.gz).<br/><br/>VCF files must also be sorted by chromosome, then by position, then by reference, then by alternate.<br/><br/>Non-canonical chrmosomes (e.g. chr6_random) will be skipped.", true)}));
        final JCheckBox JannovarBox = new JCheckBox("Perform gene-variant annotation");
        JannovarBox.setSelected(true);
        JannovarBox.setOpaque(false);
        JannovarBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportVariantsWizardWithAnnotation.this.useJannovar = JannovarBox.isSelected();
            }
        });
        page.addComponent((JComponent)JannovarBox);
        if (!ReferenceController.getInstance().getCurrentReferenceName().equals("hg19")) {
            JannovarBox.setSelected(false);
            JannovarBox.setEnabled(false);
            page.addText("Annotation only available for hg19");
        }
        final JCheckBox PhasingBox = new JCheckBox("Perform phasing");
        PhasingBox.setSelected(false);
        PhasingBox.setOpaque(false);
        PhasingBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportVariantsWizardWithAnnotation.this.doPhasing = PhasingBox.isSelected();
                if (ImportVariantsWizardWithAnnotation.this.doPhasing) {
                    JannovarBox.setSelected(true);
                }
            }
        });
        page.addComponent((JComponent)PhasingBox);
        if (!ReferenceController.getInstance().getCurrentReferenceName().equals("hg19")) {
            PhasingBox.setSelected(false);
            PhasingBox.setEnabled(false);
            page.addText("Phasing only available for hg19");
        }
        final JCheckBox homoRefBox = new JCheckBox("Include variants matching the reference (discouraged)");
        homoRefBox.setOpaque(false);
        homoRefBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportVariantsWizardWithAnnotation.this.includeHomoRef = homoRefBox.isSelected();
            }
        });
        page.addComponent((JComponent)homoRefBox);
        this.setUploadRequired(true);
        return page;
    }

    private AbstractWizardPage getAddTagsPage() {
        DefaultWizardPage page = new DefaultWizardPage("Add Tags"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        page.addText("Variants can be filtered by tag value in the Filter section.");
        page.addText("Add tags for this set of variants:");
        final String[] patternExamples = new String[]{"<Tag Name>", "Sequencer", "Sequencer Version", "Variant Caller", "Variant Caller Version", "Technician"};
        this.locationField = new JComboBox<String>(patternExamples);
        this.locationField.setEditable(true);
        JPanel tagContainer = new JPanel();
        ViewUtil.applyVerticalBoxLayout(tagContainer);
        final JTextField valueField = new JTextField();
        String startingValue = "<Value>";
        valueField.setText("<Value>");
        final JTextArea ta = new JTextArea();
        ta.setRows(10);
        ta.setCursor(Cursor.getPredefinedCursor(0));
        ta.setEditable(false);
        JLabel button = ViewUtil.createIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.ADD));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ImportVariantsWizardWithAnnotation.this.locationField.getSelectedItem().toString().isEmpty()) {
                    DialogUtils.displayError("Tag cannot be empty");
                    ImportVariantsWizardWithAnnotation.this.locationField.requestFocus();
                    return;
                }
                if (ImportVariantsWizardWithAnnotation.this.locationField.getSelectedItem().toString().equals(patternExamples[0])) {
                    DialogUtils.displayError("Enter a valid tag name");
                    ImportVariantsWizardWithAnnotation.this.locationField.requestFocus();
                    return;
                }
                if (valueField.getText().toString().isEmpty()) {
                    DialogUtils.displayError("Value cannot be empty");
                    valueField.requestFocus();
                    return;
                }
                if (valueField.getText().equals("<Value>")) {
                    DialogUtils.displayError("Enter a valid value");
                    valueField.requestFocus();
                    return;
                }
                VariantTag tag = new VariantTag((String)ImportVariantsWizardWithAnnotation.this.locationField.getSelectedItem(), valueField.getText());
                ImportVariantsWizardWithAnnotation.this.variantTags.add(tag);
                ta.append(tag.toString() + "\n");
                valueField.setText("");
            }
        });
        JPanel container2 = new JPanel();
        ViewUtil.clear(container2);
        ViewUtil.applyHorizontalBoxLayout(container2);
        container2.add(this.locationField);
        container2.add(ViewUtil.clear(new JLabel(" = ")));
        container2.add(valueField);
        container2.add(button);
        page.addComponent((JComponent)container2);
        this.locationField.setToolTipText("Current display range");
        this.locationField.setPreferredSize(LOCATION_SIZE);
        this.locationField.setMinimumSize(LOCATION_SIZE);
        valueField.setPreferredSize(LOCATION_SIZE);
        valueField.setMinimumSize(LOCATION_SIZE);
        page.addComponent((JComponent)tagContainer);
        page.addComponent((JComponent)new JScrollPane(ta));
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImportVariantsWizardWithAnnotation.this.variantTags.clear();
                ta.setText("");
                ImportVariantsWizardWithAnnotation.this.addDefaultTags(ImportVariantsWizardWithAnnotation.this.variantTags, ta);
            }
        });
        this.addDefaultTags(this.variantTags, ta);
        page.addComponent((JComponent)ViewUtil.alignRight(clear));
        return page;
    }

    private void addDefaultTags(List<VariantTag> variantTags, JTextArea ta) {
        VariantTag tag1 = new VariantTag("Uploader", LoginController.getInstance().getUserName());
        VariantTag tag2 = new VariantTag("Upload Date", new Date().toString());
        variantTags.add(tag1);
        variantTags.add(tag2);
        ta.append(tag1.toString() + "\n");
        ta.append(tag2.toString() + "\n");
    }

    private AbstractWizardPage getNotificationsPage() {
        CompletionWizardPage page = new CompletionWizardPage("Notifications"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        page.addText("Variant import may take some time. Enter your email address to be notified when the process completes.");
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(p);
        JLabel l = new JLabel("Email: ");
        this.emailField = new JTextField();
        p.add(l);
        p.add(this.emailField);
        page.addComponent((JComponent)p);
        this.autoPublish = new JCheckBox("Automatically publish data upon import completion");
        this.autoPublish.setSelected(true);
        page.addComponent((JComponent)this.autoPublish);
        page.addText("If you choose not to automatically publish, you will be prompted to publish manually upon completion. Variant publication logs all users out.");
        return page;
    }

    private AbstractWizardPage getCompletePage() {
        CompletionWizardPage page = new CompletionWizardPage("Complete"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3301, "FINISH");
                this.fireButtonEvent(3300, "NEXT");
            }
        };
        page.addText("You have completed the import submission process.");
        return page;
    }

    private AbstractWizardPage getQueuePage() {
        DefaultWizardPage page = new DefaultWizardPage("Transfer, Annotate, and Publish Variants"){
            private static final double UPLOAD_FILES_PERCENT = 20.0;
            private static final double UPDATE_DATABASE_PERCENT = 80.0;
            private final JLabel progressLabel;
            private final JButton workButton;
            private boolean inUploading;
            {
                this.progressLabel = new JLabel("You are now ready to import variants.");
                this.workButton = new JButton("Import");
                this.inUploading = false;
                this.addComponent(this.progressLabel);
                final JLabel j = new JLabel("<html>You may continue. The import process will continue in the<br>background and you will be notified upon completion.</html>");
                this.addComponent(j);
                j.setVisible(false);
                final 12 page = this;
                this.workButton.addActionListener(new ActionListener(){
                    private int notificationId;
                    private MedSavantWorker<Void> variantWorker;

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        LOG.info((Object)"Starting import worker");
                        workButton.setEnabled(false);
                        j.setVisible(true);
                        page.fireButtonEvent(3300, "BACK");
                        page.fireButtonEvent(3301, "NEXT");
                        new ProjectWorker<Void>("Importing variants", ImportVariantsWizardWithAnnotation.this.autoPublish.isSelected(), LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID()){
                            private int fileIndex;
                            {
                                this.fileIndex = 0;
                            }

                            @Override
                            protected Void runInBackground() throws Exception {
                                String email = ImportVariantsWizardWithAnnotation.this.emailField.getText();
                                if (email.isEmpty()) {
                                    email = null;
                                }
                                if (ImportVariantsWizardWithAnnotation.this.uploadRequired) {
                                    this.setIndeterminate(false);
                                    inUploading = true;
                                    LOG.info((Object)"Creating input streams");
                                    int[] transferIDs = new int[ImportVariantsWizardWithAnnotation.this.variantFiles.length];
                                    for (File file : ImportVariantsWizardWithAnnotation.this.variantFiles) {
                                        this.setStatusMessage("Uploading variants " + file.getName());
                                        transferIDs[this.fileIndex] = ClientNetworkUtils.copyFileToServer(file);
                                        ++this.fileIndex;
                                    }
                                    this.setStatusMessage("Importing variants");
                                    inUploading = false;
                                    this.setIndeterminate(true);
                                    manager.uploadVariants(LoginController.getSessionID(), transferIDs, ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), ImportVariantsWizardWithAnnotation.tagsToStringArray(ImportVariantsWizardWithAnnotation.this.variantTags), ImportVariantsWizardWithAnnotation.this.includeHomoRef, email, ImportVariantsWizardWithAnnotation.this.autoPublish.isSelected(), ImportVariantsWizardWithAnnotation.this.useJannovar, ImportVariantsWizardWithAnnotation.this.doPhasing);
                                    LOG.info((Object)"Import complete");
                                } else {
                                    LOG.info((Object)"Importing variants stored on server");
                                    this.setStatusMessage("Importing variants");
                                    manager.uploadVariants(LoginController.getSessionID(), new File(ImportVariantsWizardWithAnnotation.this.serverPathField.getText()), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), ImportVariantsWizardWithAnnotation.tagsToStringArray(ImportVariantsWizardWithAnnotation.this.variantTags), ImportVariantsWizardWithAnnotation.this.includeHomoRef, email, ImportVariantsWizardWithAnnotation.this.autoPublish.isSelected(), ImportVariantsWizardWithAnnotation.this.useJannovar, ImportVariantsWizardWithAnnotation.this.doPhasing);
                                    LOG.info((Object)"Done importing");
                                }
                                return null;
                            }

                            @Override
                            protected void showProgress(double fract) {
                                double prog = ImportVariantsWizardWithAnnotation.this.uploadRequired ? (inUploading ? 20.0 * ((double)this.fileIndex + fract) / (double)ImportVariantsWizardWithAnnotation.this.variantFiles.length : 20.0 + fract * 80.0) : fract * 100.0;
                                this.setProgress(prog / 100.0);
                            }

                            @Override
                            protected ProgressStatus checkProgress() throws RemoteException {
                                ProgressStatus stat;
                                if (inUploading) {
                                    stat = MedSavantClient.NetworkManager.checkProgress(LoginController.getSessionID(), this.isCancelled());
                                } else {
                                    try {
                                        stat = manager.checkProgress(LoginController.getSessionID(), this.isCancelled());
                                    }
                                    catch (SessionExpiredException ex) {
                                        MedSavantExceptionHandler.handleSessionExpiredException(ex);
                                        return null;
                                    }
                                }
                                if (stat != null) {
                                    this.setStatusMessage(stat.message);
                                }
                                return stat;
                            }
                        }.execute();
                        ImportVariantsWizardWithAnnotation.this.toFront();
                    }
                });
                this.addComponent(ViewUtil.alignRight(this.workButton));
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                this.fireButtonEvent(3302, "NEXT");
            }
        };
        return page;
    }

    private static String[][] tagsToStringArray(List<VariantTag> variantTags) {
        String[][] result = new String[variantTags.size()][2];
        int row = 0;
        for (VariantTag t : variantTags) {
            result[row][0] = t.key;
            result[row][1] = t.value;
            ++row;
        }
        return result;
    }

    private JPanel populateOnServerPanel(final DefaultWizardPage page) {
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyVerticalBoxLayout(p);
        this.serverPathField = new JTextField();
        ViewUtil.clear(this.serverPathField);
        this.serverPathField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                if (ImportVariantsWizardWithAnnotation.this.serverPathField.getText().isEmpty()) {
                    page.fireButtonEvent(3302, "NEXT");
                } else {
                    page.fireButtonEvent(3301, "NEXT");
                }
            }
        });
        JPanel container = ViewUtil.getClearPanel();
        ViewUtil.clear(container);
        ViewUtil.applyHorizontalBoxLayout(container);
        container.add(this.serverPathField);
        p.add(ViewUtil.alignLeft(container));
        return p;
    }

    private JPanel populateOnMyComputerPanel(final DefaultWizardPage page) {
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyVerticalBoxLayout(p);
        final JTextField outputFileField = new JTextField();
        ViewUtil.clear(outputFileField);
        outputFileField.setEnabled(false);
        JButton chooseFileButton = new JButton("...");
        chooseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImportVariantsWizardWithAnnotation.access$302(ImportVariantsWizardWithAnnotation.this, DialogUtils.chooseFilesForOpen("Import Variants", new ExtensionsFileFilter(new String[]{"vcf", "vcf.gz"}), null));
                if (ImportVariantsWizardWithAnnotation.this.variantFiles == null || ImportVariantsWizardWithAnnotation.this.variantFiles.length == 0) {
                    page.fireButtonEvent(3302, "NEXT");
                } else {
                    page.fireButtonEvent(3301, "NEXT");
                }
                String path = this.getPathString(ImportVariantsWizardWithAnnotation.this.variantFiles);
                outputFileField.setText(path);
                if (ImportVariantsWizardWithAnnotation.this.variantFiles.length > 0) {
                    page.fireButtonEvent(3301, "NEXT");
                }
            }

            private String getPathString(File[] files) {
                if (files.length > 1) {
                    return files.length + " files";
                }
                if (files.length == 1) {
                    return files[0].getAbsolutePath();
                }
                return "";
            }
        });
        JPanel container = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(container);
        container.add(outputFileField);
        container.add(chooseFileButton);
        p.add(ViewUtil.clear(ViewUtil.alignLeft(container)));
        return p;
    }

    static /* synthetic */ File[] access$302(ImportVariantsWizardWithAnnotation x0, File[] x1) {
        x0.variantFiles = x1;
        return x1;
    }
}

