/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.variant;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.CompletionWizardPage;
import com.jidesoft.wizard.DefaultWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.controller.ResultController;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.util.ExportVCF;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.util.ExtensionFileFilter;

public class ExportVCFWizard
extends WizardDialog {
    private static final Log LOG = LogFactory.getLog(ExportVCFWizard.class);
    private static final int NUM_WARNING = 1000000;
    private File variantFile = null;
    private JLabel completionLabel;

    public ExportVCFWizard() throws InterruptedException, SQLException, RemoteException {
        this.setTitle("Export VCF Wizard");
        WizardStyle.setStyle((int)3);
        PageList model = new PageList();
        model.append(this.getWelcomePage());
        model.append(this.getFilePage());
        model.append(this.getExportPage());
        model.append((AbstractDialogPage)this.getCompletionPage());
        this.setPageList(model);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    private AbstractDialogPage getWelcomePage() throws InterruptedException, SQLException, RemoteException {
        return new DefaultWizardPage("Begin"){
            {
                this.addComponent(new JLabel("<html>This wizard will allow you to export all filtered variants to a VCF file.</html>"));
                if (ResultController.getInstance().getFilteredVariantCount() > 1000000) {
                    this.addComponent(new JLabel(String.format("<html><font color=\"red\">WARNING:</font><br>There are currently more than %,d records to be exported.<br><br>This may take a long time and produce a very large file!</html>", 1000000)));
                }
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
    }

    private AbstractDialogPage getFilePage() {
        final DefaultWizardPage page = new DefaultWizardPage("Choose File"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                if (ExportVCFWizard.this.variantFile != null) {
                    this.fireButtonEvent(3301, "NEXT");
                } else {
                    this.fireButtonEvent(3302, "NEXT");
                }
            }
        };
        page.addText("Choose the file to save to:");
        final JTextField outputFileField = new JTextField();
        outputFileField.setEnabled(false);
        JButton chooseFileButton = new JButton("...");
        chooseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ExportVCFWizard.this.variantFile = DialogUtils.chooseFileForSave("Export Variants", "export.vcf", ExtensionFileFilter.createFilters(new String[]{"vcf"}), null);
                if (ExportVCFWizard.this.variantFile == null) {
                    page.fireButtonEvent(3302, "NEXT");
                } else {
                    page.fireButtonEvent(3301, "NEXT");
                    outputFileField.setText(ExportVCFWizard.this.variantFile.getAbsolutePath());
                }
            }
        });
        JPanel container = new JPanel();
        ViewUtil.clear(container);
        ViewUtil.applyHorizontalBoxLayout(container);
        container.add(outputFileField);
        container.add(chooseFileButton);
        page.addComponent((JComponent)container);
        page.addText("Files will be exported in Variant Call Format (*.vcf)");
        return page;
    }

    private AbstractDialogPage getExportPage() {
        return new DefaultWizardPage("Export"){
            private final JLabel progressLabel;
            private final JProgressBar progress;
            private final JButton workButton;
            {
                this.progressLabel = new JLabel("Click \"Start\" to begin export.");
                this.addComponent(this.progressLabel);
                this.progress = new JProgressBar();
                this.progress.setValue(0);
                this.addComponent(this.progress);
                this.workButton = new JButton("Start");
                this.workButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.fireButtonEvent(3302, "BACK");
                        new MedSavantWorker<Void>("ExportVCF"){

                            @Override
                            protected Void doInBackground() throws Exception {
                                progressLabel.setText("Exporting to VCF...");
                                workButton.removeActionListener(workButton.getActionListeners()[0]);
                                workButton.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent ae) {
                                        workButton.setEnabled(false);
                                        workButton.setText("Cancelling...");
                                        this.cancel(true);
                                    }
                                });
                                workButton.setText("Cancel");
                                ExportVCF.exportVCF(ExportVCFWizard.this.variantFile, this, FilterController.getInstance().getAllFilterConditions());
                                return null;
                            }

                            @Override
                            protected void showProgress(double fraction) {
                                progress.setValue((int)Math.round(fraction * 100.0));
                            }

                            @Override
                            protected void showSuccess(Void ignored) {
                                progressLabel.setText("Export successful.");
                                workButton.setEnabled(false);
                                this.fireButtonEvent(3301, "NEXT");
                            }

                            @Override
                            protected void showFailure(Throwable ex) {
                                progress.setValue(0);
                                workButton.setEnabled(false);
                                this.fireButtonEvent(3301, "NEXT");
                                ExportVCFWizard.this.completionLabel.setText("Export was cancelled by the user.");
                                System.out.println("Exception " + ex.getClass() + ": " + ex.getMessage());
                            }
                        }.execute();
                    }
                });
                this.addComponent(ViewUtil.alignRight(this.workButton));
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3302, "NEXT");
            }
        };
    }

    private AbstractWizardPage getCompletionPage() {
        return new CompletionWizardPage("Complete"){
            {
                ExportVCFWizard.this.completionLabel = new JLabel("Export completed successfully.");
                this.addComponent(ExportVCFWizard.this.completionLabel);
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3301, "FINISH");
                this.fireButtonEvent(3300, "NEXT");
            }
        };
    }
}

