/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.util.VisibleMedSavantWorker;

public class ThreadController {
    private static final Log LOG = LogFactory.getLog(ThreadController.class);
    private static ThreadController instance;
    private Map<String, List<MedSavantWorker>> workers = new HashMap<String, List<MedSavantWorker>>();

    public boolean areJobsRunning() {
        for (List<MedSavantWorker> list : this.workers.values()) {
            if (list == null) continue;
            for (MedSavantWorker msw : list) {
                VisibleMedSavantWorker vmsw;
                if (!(msw instanceof VisibleMedSavantWorker) || (vmsw = (VisibleMedSavantWorker)msw).getStatus() != VisibleMedSavantWorker.JobStatus.RUNNING) continue;
                return true;
            }
        }
        return false;
    }

    public static ThreadController getInstance() {
        if (instance == null) {
            instance = new ThreadController();
        }
        return instance;
    }

    public synchronized void addWorker(String page, MedSavantWorker worker) {
        List<MedSavantWorker> list = this.workers.get(page);
        if (list == null) {
            list = new ArrayList<MedSavantWorker>();
            this.workers.put(page, list);
        }
        list.add(worker);
    }

    public synchronized void removeWorker(String page, MedSavantWorker worker) {
        List<MedSavantWorker> list = this.workers.get(page);
        if (list != null) {
            list.remove(worker);
        }
    }

    public synchronized void cancelWorkers(String page) {
        List<MedSavantWorker> list = this.workers.get(page);
        if (list != null) {
            this.workers.put(page, null);
            for (MedSavantWorker worker : list) {
                worker.cancel(true);
            }
        }
    }

    public synchronized void cancelAllWorkers(MedSavantWorker except) {
        for (List<MedSavantWorker> pageWorkers : this.workers.values()) {
            if (pageWorkers == null) continue;
            for (MedSavantWorker worker : pageWorkers) {
                if (worker == except) continue;
                worker.cancel(true);
            }
        }
    }
}

