/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.util.regex.Pattern;
import org.ut.biolab.medsavant.client.util.CustomFieldConstraint;

public class RegexpConstraint
extends CustomFieldConstraint {
    public static final String REGEXP_URL_WEB = "(?i)^((https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\\s*)+$";
    public static final String REGEXP_URL = "(?i)^((https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\\s*)+$";
    public static final String REGEXP_EMAIL = "^(?i)([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,}))$";
    public static final String REGEXP_DEFAULT_VARCHAR = "(?s)^.*$";
    public static final String REGEXP_DEFAULT_INTEGER = "^[0-9]+$";
    public static final String REGEXP_DEFAULT_FLOAT = "(\\+|-)?([0-9]*(\\.[0-9]+))";
    public static final String REGEXP_DEFAULT_DECIMAL = "(\\+|-)?([0-9]*(\\.[0-9]+))";
    public static final String REGEXP_DEFAULT_DATE = "^((19|20)\\\\d\\\\d)-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01])$";
    public static final String REGEXP_DEFAULT_TEXT = "(?s)^.*$";
    private Pattern re;

    public RegexpConstraint(String regexp, boolean required, int maxlength, String errorMessage) {
        super(required, maxlength, errorMessage);
        this.re = Pattern.compile(regexp);
    }

    public RegexpConstraint(String regexp, int maxlength, String errorMessage) {
        this(regexp, false, maxlength, errorMessage);
    }

    public RegexpConstraint(String regexp, int maxlength) {
        this(regexp, maxlength, null);
    }

    @Override
    public boolean isValid(String val) {
        return super.isValid(val) && (this.isEmpty(val) || this.re.matcher(val).matches());
    }
}

