/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.user;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.user.UserController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.UserLevel;

public class NewUserDialog
extends JDialog {
    private JButton cancelButton;
    private JButton okButton;
    private JPasswordField passwordField;
    private ButtonGroup privilegeGroup;
    private JTextField usernameField;

    public NewUserDialog() {
        super(DialogUtils.getFrontWindow(), "Create User", Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        ClientMiscUtils.registerCancelButton(this.cancelButton);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.privilegeGroup = new ButtonGroup();
        JLabel jLabel1 = new JLabel();
        this.usernameField = new JTextField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        JLabel jLabel2 = new JLabel();
        this.passwordField = new JPasswordField();
        JPanel jPanel1 = new JPanel();
        JRadioButton adminRadio = new JRadioButton();
        JRadioButton userRadio = new JRadioButton();
        JRadioButton guestRadio = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        jLabel1.setHorizontalAlignment(4);
        jLabel1.setText("Username: ");
        this.usernameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewUserDialog.this.usernameFieldActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewUserDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewUserDialog.this.okButtonActionPerformed(evt);
            }
        });
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText("Password: ");
        jPanel1.setBorder(BorderFactory.createTitledBorder("User Level"));
        jPanel1.setToolTipText("Sets the level of privilege given to this user.");
        this.privilegeGroup.add(adminRadio);
        adminRadio.setText("Admin");
        adminRadio.setActionCommand("ADMIN");
        this.privilegeGroup.add(userRadio);
        userRadio.setSelected(true);
        userRadio.setText("User");
        userRadio.setActionCommand("USER");
        this.privilegeGroup.add(guestRadio);
        guestRadio.setText("Guest");
        guestRadio.setActionCommand("GUEST");
        GroupLayout jPanel1Layout = new GroupLayout((Container)jPanel1);
        jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)adminRadio).addPreferredGap(1).add((Component)userRadio).addPreferredGap(0, 118, Short.MAX_VALUE).add((Component)guestRadio).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)adminRadio).add((Component)guestRadio).add((Component)userRadio)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)jLabel1, -1, -1, Short.MAX_VALUE).add((Component)jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.usernameField, -1, 251, Short.MAX_VALUE).add((Component)this.passwordField, -1, 251, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.okButton).addPreferredGap(0).add((Component)this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)jLabel1).add((Component)this.usernameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.passwordField, -2, -1, -2)).addPreferredGap(0).add((Component)jPanel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.okButton).add((Component)this.cancelButton))));
        this.pack();
    }

    private void usernameFieldActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            String username = this.usernameField.getText();
            if (MedSavantClient.UserManager.userExists(LoginController.getSessionID(), username)) {
                DialogUtils.displayMessage("User already exists.");
            } else {
                UserController.getInstance().addUser(username, this.passwordField.getPassword(), UserLevel.valueOf(this.privilegeGroup.getSelection().getActionCommand()));
            }
            this.cancelButton.setText("Dismiss");
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error adding user: %s", ex);
        }
    }
}

