/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.view;

import com.jidesoft.list.FilterableCheckBoxList;
import com.jidesoft.list.QuickListFilterField;
import com.jidesoft.swing.SearchableUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jdesktop.swingx.prompt.PromptSupport;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.value.StringConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class StringSearchConditionEditorView
extends SearchConditionEditorView {
    private final StringConditionValueGenerator valueGenerator;
    protected QuickListFilterField field;
    private final int FIELD_WIDTH = 600;
    protected FilterableCheckBoxList filterableList;
    private List<String> values;
    private boolean cacheOn = true;
    private JButton selectNone;
    private JButton selectAll;
    private JScrollPane jsp;
    private boolean makingBatchChanges = false;
    private boolean isUserSpecifiedTextMatch = false;

    public StringSearchConditionEditorView(SearchConditionItem i, StringConditionValueGenerator vg) {
        super(i);
        if (vg == null) {
            this.isUserSpecifiedTextMatch = true;
        }
        this.valueGenerator = vg;
    }

    private void loadLooseStringMatchViewFromSearchConditionParameters(String encoding) {
        this.removeAll();
        ViewUtil.applyVerticalBoxLayout(this);
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(p);
        p.add(new JLabel("Filtering variants where " + this.item.getName() + ": "));
        ButtonGroup group = new ButtonGroup();
        JRadioButton isButton = new JRadioButton("is any of the following:");
        JRadioButton notNullButton = new JRadioButton("is not null");
        JRadioButton nullButton = new JRadioButton("is null");
        p.add(isButton);
        p.add(notNullButton);
        p.add(nullButton);
        group.add(isButton);
        group.add(notNullButton);
        group.add(nullButton);
        final JTextField f = new JTextField();
        PromptSupport.setPrompt((String)("Enter " + this.item.getName()), (JTextComponent)f);
        PromptSupport.setFocusBehavior((PromptSupport.FocusBehavior)PromptSupport.FocusBehavior.SHOW_PROMPT, (JTextComponent)f);
        f.setPreferredSize(new Dimension(200, f.getPreferredSize().height));
        f.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                StringSearchConditionEditorView.this.saveSearchConditionParameters(f.getText());
                StringSearchConditionEditorView.this.item.setDescription(f.getText());
            }
        });
        notNullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                f.setEnabled(false);
                StringSearchConditionEditorView.this.saveSearchConditionParameters(StringConditionEncoder.encodeConditions(Arrays.asList(StringConditionEncoder.ENCODING_NOTNULL)));
                StringSearchConditionEditorView.this.item.setDescription("not null");
            }
        });
        nullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                f.setEnabled(false);
                StringSearchConditionEditorView.this.saveSearchConditionParameters(StringConditionEncoder.encodeConditions(Arrays.asList(StringConditionEncoder.ENCODING_NULL)));
                StringSearchConditionEditorView.this.item.setDescription("null");
            }
        });
        isButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                f.setEnabled(true);
                StringSearchConditionEditorView.this.saveSearchConditionParameters(f.getText());
                StringSearchConditionEditorView.this.item.setDescription(f.getText());
            }
        });
        if (encoding != null) {
            if (StringConditionEncoder.encodesNull(encoding)) {
                nullButton.setSelected(true);
            } else if (StringConditionEncoder.encodesNotNull(encoding)) {
                notNullButton.setSelected(true);
            } else {
                isButton.setSelected(true);
                f.setText(encoding);
            }
        } else {
            isButton.setSelected(true);
        }
        this.add(p);
        this.add(f);
    }

    private void hideListFields() {
        this.field.setVisible(false);
        this.selectAll.setVisible(false);
        this.selectNone.setVisible(false);
        this.jsp.setVisible(false);
        this.invalidate();
    }

    private void showListFields() {
        this.field.setVisible(true);
        this.selectAll.setVisible(true);
        this.selectNone.setVisible(true);
        this.jsp.setVisible(true);
        this.invalidate();
    }

    @Override
    public void loadViewFromSearchConditionParameters(String encoding) throws SearchConditionEditorView.ConditionRestorationException {
        List<String> selectedValues;
        if (this.isUserSpecifiedTextMatch) {
            this.loadLooseStringMatchViewFromSearchConditionParameters(encoding);
            return;
        }
        this.values = this.valueGenerator.getStringValues();
        this.removeAll();
        if (this.values == null || this.values.isEmpty()) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(Box.createHorizontalGlue());
            p.add(new JLabel("<html>All values are blank for this condition.</html>"));
            p.add(Box.createHorizontalGlue());
            this.add(p);
            return;
        }
        final JRadioButton isNull = new JRadioButton("is null");
        final JRadioButton isNotNull = new JRadioButton("is not null");
        final JRadioButton is = new JRadioButton("is any of the following:");
        ButtonGroup group = new ButtonGroup();
        is.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StringSearchConditionEditorView.this.showListFields();
                StringSearchConditionEditorView.this.setDescriptionBasedOnSelections();
            }
        });
        isNull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (isNull.isSelected()) {
                    StringSearchConditionEditorView.this.setAllSelected(false, false);
                    StringSearchConditionEditorView.this.saveSearchConditionParameters(StringConditionEncoder.encodeConditions(Arrays.asList(StringConditionEncoder.ENCODING_NULL)));
                    StringSearchConditionEditorView.this.item.setDescription("is null");
                }
            }
        });
        isNotNull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (isNotNull.isSelected()) {
                    StringSearchConditionEditorView.this.setAllSelected(false, false);
                    StringSearchConditionEditorView.this.saveSearchConditionParameters(StringConditionEncoder.encodeConditions(Arrays.asList(StringConditionEncoder.ENCODING_NOTNULL)));
                    StringSearchConditionEditorView.this.item.setDescription("is not null");
                }
            }
        });
        if (encoding == null) {
            selectedValues = null;
            is.setSelected(true);
        } else {
            selectedValues = StringConditionEncoder.unencodeConditions(encoding);
        }
        group.add(isNull);
        group.add(isNotNull);
        group.add(is);
        JPanel controlButtons = ViewUtil.getClearPanel();
        controlButtons.setLayout(new BoxLayout(controlButtons, 0));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(new JLabel("Filtering variants where " + this.item.getName() + ": "));
        labelPanel.add(Box.createHorizontalGlue());
        p.add(labelPanel);
        controlButtons.add(Box.createHorizontalGlue());
        controlButtons.add(isNull);
        controlButtons.add(isNotNull);
        controlButtons.add(is);
        controlButtons.add(Box.createHorizontalGlue());
        p.add(controlButtons);
        SimpleListModel model = new SimpleListModel(this.values);
        this.field = new QuickListFilterField((ListModel)model);
        this.field.setHintText("Type here to filter options");
        this.field.setMaximumSize(new Dimension(600, 22));
        this.filterableList = new FilterableCheckBoxList((ListModel)this.field.getDisplayListModel()){

            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                return -1;
            }

            public boolean isCheckBoxEnabled(int index) {
                return true;
            }

            public ListCellRenderer getCellRenderer() {
                ListCellRenderer defaultListCellRenderer = super.getCellRenderer();
                return new ListCellRendererWithTotals(defaultListCellRenderer);
            }
        };
        this.filterableList.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){
            private JPopupMenu menu;
            private int lastIndex = -1;

            @Override
            public void mouseMoved(final MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int index = StringSearchConditionEditorView.this.filterableList.locationToIndex(e.getPoint());
                        if (index > -1) {
                            Rectangle bounds = StringSearchConditionEditorView.this.filterableList.getCellBounds(index, index);
                            ListCellRendererWithTotals cellRenderer = (ListCellRendererWithTotals)StringSearchConditionEditorView.this.filterableList.getCellRenderer();
                            Component renderComp = cellRenderer.getListCellRendererComponent((JList)StringSearchConditionEditorView.this.filterableList, StringSearchConditionEditorView.this.filterableList.getModel().getElementAt(index), index, false, false);
                            renderComp.setBounds(bounds);
                            if (cellRenderer.isMouseXOverLabel(e.getPoint())) {
                                menu = StringSearchConditionEditorView.this.getPopupMenu(StringSearchConditionEditorView.this.filterableList.getModel().getElementAt(index).toString());
                                menu.show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                        lastIndex = index;
                    }
                });
            }
        });
        this.filterableList.getCheckBoxListSelectionModel().setSelectionMode(2);
        if (model.getSize() > 0) {
            this.filterableList.setPrototypeCellValue(model.getElementAt(0));
        }
        if (selectedValues == null) {
            this.setAllSelected(true);
            this.saveSearchConditionParameters();
        } else if (StringConditionEncoder.encodesNotNull(encoding) || StringConditionEncoder.encodesNull(encoding)) {
            this.setAllSelected(false);
        } else {
            int[] selectedIndices = new int[selectedValues.size()];
            boolean err = false;
            for (int i = 0; i < selectedValues.size(); ++i) {
                selectedIndices[i] = this.values.indexOf(selectedValues.get(i));
                if (selectedIndices[i] != -1) continue;
                DialogUtils.displayError(selectedValues.get(i) + " is not an allowable option for " + this.item.getName());
                System.err.println(selectedValues.get(i) + " is not an allowable option for " + this.item.getName());
                err = true;
            }
            if (err) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StringSearchConditionEditorView.this.saveSearchConditionParameters();
                        StringSearchConditionEditorView.this.setDescriptionBasedOnSelections();
                    }
                });
            }
            ClientMiscUtils.selectOnlyTheseIndicies(this.filterableList, selectedIndices);
        }
        SearchableUtils.installSearchable((JList)this.filterableList);
        this.filterableList.getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !StringSearchConditionEditorView.this.makingBatchChanges) {
                    int[] indices = StringSearchConditionEditorView.this.filterableList.getCheckBoxListSelectedIndices();
                    ArrayList chosenValues = new ArrayList();
                    for (int i : indices) {
                        chosenValues.add(StringSearchConditionEditorView.this.values.get(i));
                    }
                    StringSearchConditionEditorView.this.saveSearchConditionParameters();
                    StringSearchConditionEditorView.this.setDescriptionBasedOnSelections();
                    is.setSelected(true);
                }
            }
        });
        StringSearchConditionEditorView instance = this;
        this.jsp = new JScrollPane((Component)this.filterableList);
        p.add((Component)this.field);
        JPanel jspContainer = new JPanel();
        jspContainer.setLayout(new BoxLayout(jspContainer, 1));
        this.jsp.add(Box.createVerticalGlue());
        jspContainer.add(this.jsp);
        p.add(jspContainer);
        this.selectAll = ViewUtil.getSoftButton("Select All");
        this.selectAll.setFocusable(false);
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                is.setSelected(true);
                StringSearchConditionEditorView.this.setAllSelected(true);
            }
        });
        this.selectNone = ViewUtil.getSoftButton("Select None");
        this.selectNone.setFocusable(false);
        this.selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                is.setSelected(true);
                StringSearchConditionEditorView.this.setAllSelected(false);
            }
        });
        JPanel bp = new JPanel();
        bp.setLayout(new BoxLayout(bp, 0));
        bp.add(this.selectAll);
        bp.add(this.selectNone);
        bp.add(Box.createHorizontalGlue());
        p.add(bp);
        if (StringConditionEncoder.encodesNull(encoding)) {
            isNull.setSelected(true);
        } else if (StringConditionEncoder.encodesNotNull(encoding)) {
            isNotNull.setSelected(true);
        } else {
            is.setSelected(true);
            this.setDescriptionBasedOnSelections();
        }
        this.add(p);
    }

    protected JPopupMenu getPopupMenu(String itemHoveredOver) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(itemHoveredOver));
        return menu;
    }

    protected JLabel getNumberInCategory(String category) {
        return new JLabel("");
    }

    private void saveSearchConditionParameters() {
        this.saveSearchConditionParameters(StringConditionEncoder.encodeConditions(this.getSelectedOptions()));
    }

    private List<String> getAvailableOptions() {
        ArrayList<String> values = new ArrayList<String>();
        int n = this.filterableList.getCheckBoxListSelectionModel().getModel().getSize();
        for (int i = 0; i < n; ++i) {
            values.add(this.filterableList.getCheckBoxListSelectionModel().getModel().getElementAt(i).toString());
        }
        return values;
    }

    private List<String> getSelectedOptions() {
        int[] indices = this.filterableList.getCheckBoxListSelectedIndices();
        ArrayList<String> chosenValues = new ArrayList<String>();
        for (int i : indices) {
            chosenValues.add(this.filterableList.getCheckBoxListSelectionModel().getModel().getElementAt(i).toString());
        }
        return chosenValues;
    }

    private void setDescriptionBasedOnSelections() {
        List<String> values = this.isUserSpecifiedTextMatch ? null : this.getAvailableOptions();
        List<String> chosenValues = this.isUserSpecifiedTextMatch ? null : this.getSelectedOptions();
        String d = StringConditionEncoder.getDescription(chosenValues, values);
        this.item.setDescription(d);
    }

    private void setAllSelected(boolean b) {
        this.setAllSelected(b, true);
    }

    private void setAllSelected(boolean b, boolean doSave) {
        this.makingBatchChanges = true;
        if (b) {
            for (int i = 0; i < this.filterableList.getModel().getSize(); ++i) {
                this.filterableList.addCheckBoxListSelectedIndex(i);
            }
        } else {
            for (int i = 0; i < this.filterableList.getModel().getSize(); ++i) {
                this.filterableList.removeCheckBoxListSelectedIndex(i);
            }
        }
        this.makingBatchChanges = false;
        if (doSave) {
            this.saveSearchConditionParameters();
            this.setDescriptionBasedOnSelections();
        }
    }

    protected class ListCellRendererWithTotals
    implements ListCellRenderer {
        private ListCellRenderer defaultListCellRenderer;
        private JLabel totalCount;

        public ListCellRendererWithTotals(ListCellRenderer defaultListCellRenderer) {
            this.defaultListCellRenderer = defaultListCellRenderer;
        }

        public Component getListCellRendererComponent(JList jlist, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.defaultListCellRenderer.getListCellRendererComponent(jlist, value, index, isSelected, cellHasFocus);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(c);
            p.add(Box.createHorizontalGlue());
            this.totalCount = StringSearchConditionEditorView.this.getNumberInCategory((String)value);
            p.add(this.totalCount);
            return p;
        }

        public boolean isMouseXOverLabel(Point p) {
            Point l = this.totalCount.getLocation();
            return p.x >= l.x && p.x <= l.x + this.totalCount.getWidth();
        }
    }

    protected class SimpleListModel
    extends AbstractListModel {
        private final List<String> items;

        public SimpleListModel(List<String> items) {
            this.items = items;
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public Object getElementAt(int i) {
            String val = this.items.get(i);
            if (val instanceof String && val.length() == 0) {
                return "<empty>";
            }
            return val;
        }
    }
}

