/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.ut.biolab.medsavant.client.filter.SearchBar;
import org.ut.biolab.medsavant.client.query.view.ConditionEditorDialogGenerator;
import org.ut.biolab.medsavant.client.query.view.ConditionPopupGenerator;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class PillView
extends JPanel {
    public static final Color[] COLOR_SCHEME_INACTIVE = new Color[]{new Color(241, 215, 215), new Color(233, 139, 139), new Color(233, 49, 49), new Color(239, 97, 97)};
    public static final Color[] COLOR_SCHEME_ACTIVE = new Color[]{new Color(222, 231, 241), new Color(166, 190, 236), new Color(49, 121, 233), new Color(97, 155, 239)};
    private static final int MAXIMUM_HEIGHT = 100;
    private static final int LEFT_BORDER_OFFSET = 10;
    public static final int BACKOFF = 1;
    public static final int VPAD = 2;
    public static final int HPAD = 7;
    private static final int DIALOG_HEIGHT = 384;
    private static final int DIALOG_WIDTH = 512;
    private boolean isDisclosureVisible;
    private final JPanel leftPanel;
    private final JPanel middlePanel;
    private final JPanel rightPanel;
    private ConditionEditorDialogGenerator dialogGenerator;
    private ConditionPopupGenerator popupGenerator;
    private boolean isActivated;
    private boolean isSelected;
    private JLabel textLabel;
    private JLabel expandButton;
    private JButton editButton;
    private JLabel infoButton;
    private String info;
    private final Component infoButtonPadding;
    private boolean expandState = false;

    public static int getAllowedWidth(int depth) {
        int w = SearchBar.getInstance().getWidth() - 14;
        for (int i = 0; i < depth; ++i) {
            w -= 8;
        }
        return w;
    }

    public final void indent(int depth) {
        this.setMaximumSize(new Dimension(PillView.getAllowedWidth(depth), 100));
    }

    public PillView() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(2, 7, 2, 7));
        this.setOpaque(false);
        this.leftPanel = new JPanel();
        this.middlePanel = new JPanel();
        this.rightPanel = new JPanel();
        this.leftPanel.setOpaque(false);
        this.middlePanel.setOpaque(false);
        this.middlePanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.rightPanel.setOpaque(false);
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 0));
        this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 0));
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 0));
        this.add(this.leftPanel);
        this.add(this.middlePanel);
        this.add(this.rightPanel);
        this.setIsDisclosureVisible(true);
        this.indent(0);
        final PillView instance = this;
        ImageIcon icinfo = IconFactory.getInstance().getIcon(IconFactory.StandardIcon.INFO);
        this.infoButton = ViewUtil.createIconButton(icinfo);
        this.infoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PillView.this.showInfoPopup();
            }
        });
        this.infoButton.setVisible(false);
        this.infoButtonPadding = Box.createHorizontalStrut(2);
        this.infoButtonPadding.setVisible(this.infoButton.isVisible());
        this.editButton = ViewUtil.getConfigureButton();
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PillView.this.dialogGenerator != null) {
                    PillView.this.showDialog(instance.getLocationOnScreen());
                } else if (PillView.this.popupGenerator != null) {
                    PillView.this.showPopup();
                }
            }
        });
        this.setRightPanel(ViewUtil.horizontallyAlignComponents(new Component[]{this.infoButton, this.infoButtonPadding, this.editButton}));
    }

    public PillView(boolean expandable) {
        this();
        ImageIcon ic = IconFactory.getInstance().getIcon(IconFactory.StandardIcon.COLLAPSE);
        this.expandButton = ViewUtil.createIconButton(ic);
        this.expandButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PillView.this.toggleExpandButton(!PillView.this.expandState);
                PillView.this.updateUI();
            }
        });
    }

    public void setActivated(boolean b) {
        this.isActivated = b;
    }

    public void setInfo(String info) {
        this.infoButton.setVisible(true);
        this.infoButtonPadding.setVisible(this.infoButton.isVisible());
        this.info = info;
    }

    public void showInfoPopup() {
        JDialog d = ViewUtil.getHUD(this.infoButton, this.textLabel.getText(), this.info);
        d.setVisible(true);
    }

    public void showPopup() {
        if (this.isDisclosureVisible) {
            final JPopupMenu m = this.popupGenerator.generatePopup();
            PillView instance = this;
            m.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
                    PillView.this.setSelected(true);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
                    PillView.this.setSelected(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent pme) {
                    PillView.this.setSelected(false);
                }
            });
            m.show(this, ViewUtil.getPositionRelativeTo((Component)instance, (Component)this.editButton).x, this.getHeight());
            final PillView pillInstance = this;
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent ce) {
                }

                @Override
                public void componentMoved(ComponentEvent ce) {
                    if (m.isVisible()) {
                        m.show(pillInstance, PillView.this.editButton.getX(), pillInstance.getHeight());
                    }
                }

                @Override
                public void componentShown(ComponentEvent ce) {
                }

                @Override
                public void componentHidden(ComponentEvent ce) {
                }
            });
        }
    }

    public void showDialog(Point p) {
        this.showDialog(p, "Editing Condition: ");
    }

    public void showDialog(Point p, String title) {
        if (this.dialogGenerator != null && this.isDisclosureVisible) {
            final JDialog jd = this.dialogGenerator.generateDialog();
            jd.setTitle(title);
            jd.setDefaultCloseOperation(0);
            jd.pack();
            int y = p.y + this.getHeight() + 2;
            int frameHeight = MedSavantFrame.getInstance().getHeight();
            if (y + 384 > frameHeight) {
                y = frameHeight - 384 - 10;
            }
            jd.setLocation(new Point(p.x, y));
            this.setSelected(true);
            this.repaint();
            jd.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PillView.this.setSelected(false);
                    jd.dispose();
                    PillView.this.repaint();
                }
            });
            jd.setVisible(true);
            jd.requestFocus();
        }
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
        if (this.textLabel != null) {
            if (b) {
                this.textLabel.setForeground(Color.white);
            } else {
                this.textLabel.setForeground(Color.darkGray);
            }
        }
        this.updateDisclosure();
        this.updateUI();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color[] currentColorSheme = this.isActivated ? COLOR_SCHEME_ACTIVE : COLOR_SCHEME_INACTIVE;
        int bend = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isSelected) {
            Color bottom = currentColorSheme[2];
            Color top = currentColorSheme[3];
            GradientPaint redtowhite = new GradientPaint(0.0f, 0.0f, top, 0.0f, this.getHeight(), bottom);
            g2.setPaint(redtowhite);
        } else {
            g2.setColor(currentColorSheme[0]);
        }
        g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), bend, bend);
        g2.setColor(currentColorSheme[1]);
        RoundRectangle2D.Double rec2 = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, bend, bend);
        g2.draw(rec2);
        g2.clip(rec2);
        if (this.textLabel != null) {
            if (this.isSelected) {
                this.textLabel.setForeground(Color.white);
            } else {
                this.textLabel.setForeground(Color.darkGray);
            }
        }
    }

    private void setIsDisclosureVisible(boolean b) {
        this.isDisclosureVisible = b;
        this.updateDisclosure();
    }

    private void toggleExpandButton(boolean expand) {
        if (this.expandButton != null) {
            this.expandState = expand;
            ImageIcon ic = IconFactory.getInstance().getIcon(expand ? IconFactory.StandardIcon.COLLAPSE : IconFactory.StandardIcon.EXPAND);
            this.expandButton.setIcon(ic);
        }
    }

    public void setExpandListener(final ActionListener l) {
        if (this.expandButton != null) {
            this.expandButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    l.actionPerformed(null);
                }
            });
        }
    }

    public void toggleExpandButton() {
        this.toggleExpandButton(!this.expandState);
    }

    public void expand() {
        this.toggleExpandButton(true);
        this.updateUI();
    }

    public void collapse() {
        this.toggleExpandButton(false);
        this.updateUI();
    }

    public void setText(String text) {
        this.middlePanel.removeAll();
        if (this.expandButton != null) {
            this.middlePanel.add(this.expandButton);
        }
        this.textLabel = new JLabel(text);
        this.textLabel.setFont(new Font(this.textLabel.getFont().getFamily(), 0, 13));
        this.textLabel.setOpaque(false);
        this.middlePanel.add(this.textLabel);
        this.updateUI();
    }

    private void setLeftPanel(JComponent c) {
        this.leftPanel.removeAll();
        if (c != null) {
            this.leftPanel.add(c);
            this.leftPanel.add(Box.createHorizontalStrut(4));
        }
        this.updateUI();
    }

    private void setRightPanel(JComponent c) {
        this.rightPanel.removeAll();
        if (c != null) {
            this.rightPanel.add(Box.createHorizontalStrut(4));
            this.rightPanel.add(c);
        }
        this.updateUI();
    }

    private void updateDisclosure() {
        this.leftPanel.removeAll();
    }

    public void setDialogGenerator(ConditionEditorDialogGenerator pg) {
        this.dialogGenerator = pg;
    }

    public void setPopupGenerator(ConditionPopupGenerator cpg) {
        this.popupGenerator = cpg;
    }
}

