/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.medsavant.complex;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantConditionViewGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantDatabaseNumberConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantDatabaseStringConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ComprehensiveConditionGenerator;
import org.ut.biolab.medsavant.client.query.value.StringConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.value.encode.NumericConditionEncoder;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.query.view.NumberSearchConditionEditorView;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import org.ut.biolab.medsavant.client.query.view.StringSearchConditionEditorView;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class VariantConditionGenerator
implements ComprehensiveConditionGenerator {
    boolean allowInexactMatch;
    private final String columnName;
    private final String alias;
    private final CustomField field;
    private List<String> columnsToForceStringView = Arrays.asList(BasicVariantColumns.AC.getColumnName(), BasicVariantColumns.AN.getColumnName(), BasicVariantColumns.UPLOAD_ID.getColumnName(), BasicVariantColumns.FILE_ID.getColumnName());
    private final HashMap<String, Map> columnNameToRemapMap;
    private static final WhichTable whichTable = WhichTable.VARIANT;

    public VariantConditionGenerator(String alias, CustomField field) {
        this.columnName = field.getColumnName();
        this.alias = alias;
        this.field = field;
        this.columnNameToRemapMap = new HashMap();
        TreeMap<String, String> zygosityRemap = new TreeMap<String, String>();
        zygosityRemap.put("Homozygous Reference", "HomoRef");
        zygosityRemap.put("Homozygous Alternate", "HomoAlt");
        zygosityRemap.put("Heterozygous", "Hetero");
        zygosityRemap.put("Heterozygous (Triallelic)", "HeteroTriallelic");
        zygosityRemap.put("Missing", "Missing");
        this.columnNameToRemapMap.put(BasicVariantColumns.ZYGOSITY.getColumnName(), zygosityRemap);
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public String category() {
        return "Variants";
    }

    @Override
    public Condition getConditionsFromEncoding(String encoding) throws Exception {
        if (this.columnsToForceStringView.contains(this.columnName)) {
            return this.generateStringConditionForVariantDatabaseField(encoding);
        }
        switch (this.field.getColumnType()) {
            case INTEGER: 
            case FLOAT: 
            case DECIMAL: {
                return this.generateNumericConditionForVariantDatabaseField(encoding);
            }
        }
        return this.generateStringConditionForVariantDatabaseField(encoding);
    }

    @Override
    public SearchConditionEditorView getViewGeneratorForItem(SearchConditionItem item) {
        return this.generateViewFromDatabaseField(item);
    }

    private SearchConditionEditorView generateViewFromDatabaseField(SearchConditionItem item) {
        if (this.columnsToForceStringView.contains(this.columnName)) {
            return this.generateStringViewFromDatabaseField(item);
        }
        switch (this.field.getColumnType()) {
            case INTEGER: 
            case FLOAT: 
            case DECIMAL: {
                return this.generateNumericViewFromDatabaseField(item);
            }
        }
        return this.generateStringViewFromDatabaseField(item);
    }

    private StringSearchConditionEditorView generateStringViewFromDatabaseField(SearchConditionItem item) {
        String colName = this.field.getColumnName();
        Object valueGenerator = colName.equals(BasicVariantColumns.ALT.getColumnName()) || colName.equals(BasicVariantColumns.REF.getColumnName()) || colName.equals(BasicVariantColumns.AA.getColumnName()) ? new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                return Arrays.asList("A", "C", "G", "T");
            }
        } : (colName.equals(BasicVariantColumns.VARIANT_TYPE.getColumnName()) ? new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                ArrayList<String> vtList = new ArrayList<String>(VariantRecord.VariantType.values().length);
                for (VariantRecord.VariantType vt : VariantRecord.VariantType.values()) {
                    vtList.add(vt.toString());
                }
                return vtList;
            }
        } : (colName.equals(BasicVariantColumns.ZYGOSITY.getColumnName()) ? new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                return Arrays.asList("Homozygous Reference", "Homozygous Alternate", "Heterozygous", "Heterozygous (Triallelic)", "Missing");
            }
        } : (colName.equals(BasicVariantColumns.DBSNP_ID.getColumnName()) ? null : new MedSavantDatabaseStringConditionValueGenerator(this.field, whichTable))));
        VariantStringConditionEditorView editor = new VariantStringConditionEditorView(item, (StringConditionValueGenerator)valueGenerator);
        return editor;
    }

    private NumberSearchConditionEditorView generateNumericViewFromDatabaseField(SearchConditionItem item) {
        NumberSearchConditionEditorView editor = new NumberSearchConditionEditorView(item, new MedSavantDatabaseNumberConditionValueGenerator(this.field, whichTable));
        return editor;
    }

    private Condition generateStringConditionForVariantDatabaseField(String encoding) {
        DbColumn col = ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(this.field.getColumnName());
        if (StringConditionEncoder.encodesNull(encoding)) {
            return ComboCondition.or(UnaryCondition.isNull(col), BinaryCondition.equalTo(col, ""));
        }
        if (StringConditionEncoder.encodesNotNull(encoding)) {
            return ComboCondition.and(UnaryCondition.isNotNull(col), BinaryCondition.notEqualTo(col, ""));
        }
        List<String> selected = StringConditionEncoder.unencodeConditions(encoding);
        if (this.columnNameToRemapMap.containsKey(this.columnName)) {
            selected = this.remapValues(selected, this.columnNameToRemapMap.get(this.columnName));
        }
        if (selected.isEmpty()) {
            return BinaryCondition.equalTo(1, 0);
        }
        Condition[] conditions = new Condition[selected.size()];
        int i = 0;
        for (String select : selected) {
            conditions[i++] = BinaryCondition.equalTo(col, select);
        }
        return ComboCondition.or(conditions);
    }

    private Condition generateVariantConditionForDatabaseField(MedSavantConditionViewGenerator.DatabaseFieldStruct s, String encoding) {
        String colName = this.field.getColumnName();
        if (this.columnsToForceStringView.contains(colName)) {
            return this.generateStringConditionForVariantDatabaseField(encoding);
        }
        switch (this.field.getColumnType()) {
            case INTEGER: 
            case FLOAT: 
            case DECIMAL: {
                return this.generateNumericConditionForVariantDatabaseField(encoding);
            }
        }
        return this.generateStringConditionForVariantDatabaseField(encoding);
    }

    private Condition generateNumericConditionForVariantDatabaseField(String encoding) {
        DbColumn col = ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(this.field.getColumnName());
        boolean includeNull = NumericConditionEncoder.encodesNull(encoding);
        double[] selected = NumericConditionEncoder.unencodeConditions(encoding);
        if (selected[0] == selected[1]) {
            if (includeNull) {
                return ComboCondition.or(BinaryCondition.equalTo(col, selected[0]), UnaryCondition.isNull(col));
            }
            return BinaryCondition.equalTo(col, selected[0]);
        }
        if (includeNull) {
            return ComboCondition.or(ComboCondition.and(BinaryCondition.greaterThan(col, selected[0], true), BinaryCondition.lessThan(col, selected[1], true)), UnaryCondition.isNull(col));
        }
        return ComboCondition.and(BinaryCondition.greaterThan(col, selected[0], true), BinaryCondition.lessThan(col, selected[1], true));
    }

    private List<String> remapValues(List<String> appliedValues, Map<String, String> remap) {
        ArrayList<String> remappedAppliedValues = new ArrayList<String>();
        for (String s : appliedValues) {
            System.out.println("Remapping " + s + " to " + remap.get(s));
            remappedAppliedValues.add(remap.get(s));
        }
        return remappedAppliedValues;
    }

    private class VariantStringConditionEditorView
    extends StringSearchConditionEditorView {
        public VariantStringConditionEditorView(SearchConditionItem i, StringConditionValueGenerator vg) {
            super(i, vg);
        }
    }
}

