/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.medsavant.complex;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.geneset.GeneSetController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantConditionViewGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ComprehensiveConditionGenerator;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.query.view.GeneSearchConditionEditorView;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import savant.api.util.DialogUtils;

public class GenesConditionGenerator
implements ComprehensiveConditionGenerator {
    private static final Log LOG = LogFactory.getLog(GenesConditionGenerator.class);
    private static final String NAME = "Genes";
    private static int[] REFRESH_KEY_CODES = new int[]{10, 32, 9, 65487};
    private static String GENE_DELIMITER = "\\s+|\\t+|,|\\n|\\r\\n";
    private static final Color GENE_INVALID_COLOR = Color.RED;
    private static final Color GENE_VALID_COLOR = Color.BLACK;
    private static final Dimension PREFERRED_SIZE = new Dimension(80, 150);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String category() {
        return MedSavantConditionViewGenerator.REGIONBASED_CONDITIONS;
    }

    @Override
    public Condition getConditionsFromEncoding(String encoding) throws Exception {
        List<String> geneNames = StringConditionEncoder.unencodeConditions(encoding);
        Condition[] conditions = new Condition[geneNames.size()];
        int i = 0;
        for (String geneName : geneNames) {
            Gene gene = GeneSetController.getInstance().getGene(geneName);
            if (gene == null) {
                LOG.error((Object)("Search error, the gene " + geneName + " is no longer valid"));
                DialogUtils.displayError((String)"Search Error", (String)("The gene " + geneName + " is no longer valid, returning unfiltered variants."));
                return null;
            }
            TableSchema ts = ProjectController.getInstance().getCurrentVariantTableSchema();
            conditions[i] = ComboCondition.and(BinaryCondition.equalTo(ts.getDBColumn(BasicVariantColumns.CHROM), gene.getChrom()), MiscUtils.getIntersectCondition(gene.getStart(), gene.getEnd(), ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.START_POSITION), ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.END_POSITION)));
            ++i;
        }
        return ComboCondition.or(conditions);
    }

    @Override
    public SearchConditionEditorView getViewGeneratorForItem(SearchConditionItem item) {
        return new GeneSearchConditionEditorView(item);
    }
}

