/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query;

import java.util.ArrayList;
import java.util.List;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;

public class SearchConditionGroupItem
extends SearchConditionItem
implements SearchConditionItem.SearchConditionListener {
    private final List<SearchConditionItem> items;
    private static int groupNo;
    private final int thisGroupNo = ++groupNo;

    public SearchConditionGroupItem(SearchConditionGroupItem parent) {
        this(QueryRelation.AND, parent);
    }

    public SearchConditionGroupItem(QueryRelation r, SearchConditionItem i, SearchConditionGroupItem parent) {
        super(null, r, parent);
        this.items = new ArrayList<SearchConditionItem>();
        if (i != null) {
            this.items.add(i);
            i.setParent(this);
            i.addListener(this);
        }
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public String getName() {
        return "Group " + this.thisGroupNo;
    }

    public boolean isFirstItem(SearchConditionItem item) {
        return this.items.indexOf(item) == 0;
    }

    public SearchConditionGroupItem(QueryRelation r, SearchConditionGroupItem parent) {
        this(r, null, parent);
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.items.size(); ++i) {
            SearchConditionItem item = this.items.get(i);
            s = item instanceof SearchConditionGroupItem ? s + "(" + item.toString() + ")" : s + item.toString();
            if (i == this.items.size()) continue;
            s = s + " " + (Object)((Object)this.getRelation()) + " ";
        }
        return s;
    }

    @Override
    protected String toXML(int indent) {
        String tab = "";
        for (int i = 0; i < indent; ++i) {
            tab = tab + "\t";
        }
        String xml = tab + "<Group ";
        xml = xml + " queryRelation=\"" + this.escape(this.getRelation().toString()) + "\"";
        if (this.getDescription() != null) {
            xml = xml + " description=\"" + this.escape(this.getDescription()) + "\"";
        }
        xml = xml + ">\n";
        for (SearchConditionItem sci : this.items) {
            xml = xml + sci.toXML(indent + 1);
        }
        xml = xml + tab + "</Group>\n";
        return xml;
    }

    @Override
    public String toXML() {
        return this.toXML(0);
    }

    public void removeItem(SearchConditionItem i) {
        i.removeListener(this);
        this.items.remove(i);
        i.setParent(null);
        if (this.items.isEmpty() && this.getParent() != null) {
            this.getParent().removeItem(this);
        } else {
            this.fireSearchConditionOrderChangedEvent();
            this.fireSearchConditionItemRemovedEvent(i);
        }
    }

    public void addItem(SearchConditionItem i, int atIndex) {
        i.addListener(this);
        i.setParent(this);
        this.items.add(atIndex, i);
        this.fireSearchConditionOrderChangedEvent();
        this.fireSearchConditionItemAddedEvent(i);
    }

    public void addItem(SearchConditionItem i) {
        this.addItem(i, this.items.size());
    }

    public void createGroupFromItem(SearchConditionItem i) {
        i.removeListener(this);
        int indexOfItem = this.items.indexOf(i);
        this.items.remove(i);
        SearchConditionGroupItem g = new SearchConditionGroupItem(QueryRelation.AND, i, this);
        this.addItem(g, indexOfItem);
    }

    public void moveItemToGroupAtIndex(SearchConditionItem i, SearchConditionGroupItem g, int newIndex) {
        i.removeListener(this);
        this.items.remove(i);
        i.setParent(null);
        g.addItem(i);
        g.moveItemToIndex(i, newIndex);
        this.fireSearchConditionOrderChangedEvent();
    }

    public void moveItemToGroup(SearchConditionItem i, SearchConditionGroupItem g) {
        i.removeListener(this);
        this.items.remove(i);
        i.setParent(null);
        g.addItem(i);
        if (this.items.size() < 1) {
            if (this.getParent() != null) {
                this.getParent().removeItem(this);
            }
        } else {
            this.fireSearchConditionOrderChangedEvent();
        }
    }

    public void moveItemToIndex(SearchConditionItem i, int newIndex) {
        int currentIndex = this.items.indexOf(i);
        this.items.remove(i);
        this.items.add(newIndex, i);
        this.fireSearchConditionOrderChangedEvent();
    }

    public void clearItems() {
        for (SearchConditionItem i : this.items) {
            i.removeListener(this);
        }
        this.items.removeAll(this.items);
        this.fireSearchConditionOrderChangedEvent();
    }

    public List<SearchConditionItem> getItems() {
        return this.items;
    }

    @Override
    public void searchConditionsOrderChanged(SearchConditionItem m) {
        this.fireSearchConditionOrderChangedEvent();
    }

    @Override
    public void searchConditionItemRemoved(SearchConditionItem m) {
        this.fireSearchConditionItemRemovedEvent(m);
    }

    @Override
    public void searchConditionItemAdded(SearchConditionItem m) {
        this.fireSearchConditionItemAddedEvent(m);
    }

    @Override
    public void searchConditionEdited(SearchConditionItem m) {
        this.fireSearchConditionsEditedEvent(m);
    }

    public static enum QueryRelation {
        AND{

            public String toString() {
                return "and";
            }
        }
        ,
        OR{

            public String toString() {
                return "or";
            }
        };

    }
}

