/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient.pedigree;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.JFrame;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.patient.pedigree.PedigreeCanvas;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.login.LoginController;

public class PedigreeWorker
extends MedSavantWorker<File> {
    private final int patientID;
    private PedigreeCanvas canvas;

    public PedigreeWorker(int patID, PedigreeCanvas canvas) {
        super("Pedigree");
        this.patientID = patID;
        this.canvas = canvas;
    }

    @Override
    protected File doInBackground() throws Exception {
        System.out.println("Fetching family of patient " + this.patientID + "...");
        List<Object[]> results = MedSavantClient.PatientManager.getFamilyOfPatient(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.patientID);
        System.out.println("Starting pedigree worker...");
        File outfile = new File(DirectorySettings.getTmpDirectory(), "pedigree" + this.patientID + ".csv");
        if (outfile.exists()) {
            outfile.delete();
        }
        System.out.println("Writing to " + outfile.getAbsolutePath());
        CSVWriter w = new CSVWriter((Writer)new FileWriter(outfile), ',', '\u0000');
        System.out.println("Writing header...");
        w.writeNext(new String[]{"HOSPITAL", "MOM", "DAD", "PATIENT", "GENDER", "AFFECTED", "DNA_ID"});
        System.out.println("Writing fields...");
        for (Object[] row : results) {
            String[] srow = new String[row.length];
            for (int i = 0; i < row.length; ++i) {
                String entry;
                srow[i] = entry = row[i] == null ? "" : row[i].toString();
            }
            w.writeNext(srow);
        }
        w.close();
        return outfile;
    }

    @Override
    protected void showProgress(double ignored) {
    }

    @Override
    protected void showSuccess(File result) {
        this.canvas.showPedigree(result, this.patientID);
    }

    private void showPedigree(String absolutePath) {
        JFrame f = new JFrame("/Users/mfiume/.medsavant/tmp/pedigree1.csv");
        PedigreeCanvas pc = new PedigreeCanvas();
        pc.showPedigree(new File(absolutePath), this.patientID);
        f.add(pc);
        f.pack();
        f.setVisible(true);
    }
}

