/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient.pedigree;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.ut.biolab.medsavant.client.view.font.FontFactory;
import pedviz.view.NodeView;
import pedviz.view.symbols.Symbol2D;

public class NameSymbol
extends Symbol2D {
    private boolean showId = true;
    private boolean patientLabelsShown;

    public NameSymbol(boolean patientLabelsShown) {
        this.patientLabelsShown = patientLabelsShown;
    }

    public void drawSymbol(Graphics2D g, Point2D.Float position, float size, Color border, Color fill, NodeView nodeview) {
        if (this.patientLabelsShown) {
            float top = position.y + size / 2.0f + 0.5f;
            Font oldfont = g.getFont();
            g.setColor(border);
            Font font = new Font(FontFactory.getGeneralFont().getFamily(), 0, 1);
            g.setFont(font);
            float height = g.getFontMetrics().getHeight();
            float y = top + height;
            if (this.showId) {
                String text = nodeview.getNode().getId().toString();
                float width = g.getFontMetrics().stringWidth(text);
                g.drawString(text, position.x - width / 2.0f, y - (float)((int)(size * 0.5f)) / 2.0f);
                y += height;
            }
            g.setFont(oldfont);
        }
    }

    public int getPriority() {
        return 1;
    }

    public Float getHeight() {
        return Float.valueOf(0.5f + 4.0f * (this.showId ? 1.0f : 0.0f));
    }
}

