/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient;

import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommHandler;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommRegistry;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.BAMFileComm;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.PatientVariantAnalyzeComm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.patient.EditablePatientField;
import org.ut.biolab.medsavant.client.patient.Patient;
import org.ut.biolab.medsavant.client.patient.pedigree.PedigreeCanvas;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.dialog.ComboForm;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.StandardFixableWidthAppPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.component.field.editable.EditableField;
import org.ut.biolab.medsavant.component.field.editable.EditableFieldValidator;
import org.ut.biolab.medsavant.component.field.editable.EnumEditableField;
import org.ut.biolab.medsavant.component.field.editable.FieldCommittedListener;
import org.ut.biolab.medsavant.component.field.editable.StringEditableField;
import org.ut.biolab.medsavant.component.field.validator.URLValidator;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class PatientView
extends JPanel
implements FieldCommittedListener {
    private Patient patient;
    private KeyValuePairPanel profileKVP;
    public static final String FATHER_ID = "Father ID";
    public static final String MOTHER_ID = "Mother ID";
    public static final String FAMILY_ID = "Family ID";
    public static final String AFFECTED = "Affected";
    public static final String HOSPITAL_ID = "Hospital ID";
    public static final String SEX = "Sex";
    public static final String DNA_ID = "DNA ID";
    public static final String BAM_URL = "Read Alignment URL";
    public static final String PHENOTYPE = "HPO IDs";
    private KeyValuePairPanel geneticsKVP;
    private KeyValuePairPanel phenotypeKVP;
    private StandardFixableWidthAppPanel content;
    private JPanel cohortListPanel;

    public PatientView() {
        this.initView();
    }

    public PatientView(Patient patient) {
        this.initView();
        this.setPatient(patient);
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        this.content = new StandardFixableWidthAppPanel();
        this.add((Component)this.content, "Center");
        this.initBlocks();
    }

    private KeyValuePairPanel getKVP() {
        KeyValuePairPanel kvp = new KeyValuePairPanel(1, true);
        return kvp;
    }

    private void initBlocks() {
        JPanel subsectionBasicInfo = this.content.addBlock("Basic Information");
        JPanel subsectionCohort = this.content.addBlock("Cohort(s)");
        JPanel subsectionGenetics = this.content.addBlock("Genetics");
        JPanel subsectionPhenotypes = this.content.addBlock("Phenotypes");
        JButton addToCohortButton = ViewUtil.getSoftButton("Add to cohort...");
        this.cohortListPanel = ViewUtil.getClearPanel();
        addToCohortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object[] cohorts = MedSavantClient.CohortManager.getCohorts(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
                    ComboForm form = new ComboForm(cohorts, "Select Cohort", "Select which cohort to add to:");
                    form.setVisible(true);
                    Cohort selected = (Cohort)form.getSelectedValue();
                    if (selected == null) {
                        return;
                    }
                    MedSavantClient.CohortManager.addPatientsToCohort(LoginController.getSessionID(), new int[]{PatientView.this.patient.getID()}, selected.getId());
                    PatientView.this.refreshView();
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Error adding individuals to cohort: %s", ex);
                }
            }
        });
        subsectionCohort.setLayout((LayoutManager)new MigLayout("insets 0"));
        subsectionCohort.add((Component)this.cohortListPanel, "wrap");
        subsectionCohort.add(addToCohortButton);
        this.profileKVP = this.getKVP();
        this.profileKVP.addKeyWithValue(HOSPITAL_ID, "");
        this.profileKVP.addKeyWithValue(SEX, "");
        this.profileKVP.addKeyWithValue(AFFECTED, "");
        this.profileKVP.addKeyWithValue(FAMILY_ID, "");
        this.profileKVP.addKeyWithValue(MOTHER_ID, "");
        this.profileKVP.addKeyWithValue(FATHER_ID, "");
        subsectionBasicInfo.add(this.profileKVP);
        this.geneticsKVP = this.getKVP();
        this.geneticsKVP.addKeyWithValue(DNA_ID, "");
        this.geneticsKVP.addKeyWithValue(BAM_URL, "");
        subsectionGenetics.add(this.geneticsKVP);
        this.phenotypeKVP = this.getKVP();
        this.phenotypeKVP.addKeyWithValue(PHENOTYPE, "");
        subsectionPhenotypes.add(this.phenotypeKVP);
    }

    void setPatient(Patient patient) {
        this.patient = patient;
        this.refreshView();
    }

    private void refreshView() {
        this.content.setTitle(this.patient.getHospitalID());
        StringEditableField individualIDField = new StringEditableField();
        individualIDField.setTag(HOSPITAL_ID);
        individualIDField.setValue((Object)this.patient.getHospitalID());
        individualIDField.addFieldComittedListener((FieldCommittedListener)this);
        EnumEditableField sexField = new EnumEditableField((Object[])new String[]{"Undesignated", "Male", "Female"});
        sexField.setValue((Object)this.patient.getSex());
        sexField.setTag(SEX);
        sexField.addFieldComittedListener((FieldCommittedListener)this);
        EnumEditableField affectedField = new EnumEditableField((Object[])new String[]{"Yes", "No"});
        affectedField.setValue((Object)(this.patient.isAffected() ? "Yes" : "No"));
        affectedField.setTag(AFFECTED);
        affectedField.addFieldComittedListener((FieldCommittedListener)this);
        EditablePatientField motherField = new EditablePatientField(true);
        motherField.setValue(this.patient.getMotherHospitalID());
        motherField.setTag(MOTHER_ID);
        motherField.addFieldComittedListener(this);
        EditablePatientField fatherField = new EditablePatientField(true);
        fatherField.setValue(this.patient.getFatherHospitalID());
        fatherField.setTag(FATHER_ID);
        fatherField.addFieldComittedListener(this);
        StringEditableField familyIDField = new StringEditableField();
        familyIDField.setValue((Object)this.patient.getFamilyID());
        familyIDField.setTag(FAMILY_ID);
        familyIDField.addFieldComittedListener((FieldCommittedListener)this);
        JButton pedigree = ViewUtil.getSoftButton("Pedigree");
        if (this.patient.getFamilyID() == null || this.patient.getFamilyID().isEmpty()) {
            pedigree.setEnabled(false);
        } else {
            pedigree.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog f = new JDialog(MedSavantFrame.getInstance(), "Pedigree Viewer", true);
                    PedigreeCanvas pc = new PedigreeCanvas();
                    pc.setFamilyName(PatientView.this.patient.getFamilyID());
                    pc.showPedigreeFor(PatientView.this.patient.getID());
                    f.setPreferredSize(new Dimension(650, 500));
                    f.setLayout(new BorderLayout());
                    f.add((Component)pc, "Center");
                    f.pack();
                    f.setLocationRelativeTo(MedSavantFrame.getInstance());
                    f.setVisible(true);
                }
            });
        }
        final JButton dnaIDButton = ViewUtil.getSoftButton("Open with...");
        if (this.patient.getDnaID() == null || this.patient.getDnaID().isEmpty()) {
            dnaIDButton.setEnabled(false);
        } else {
            dnaIDButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPopupMenu m = new JPopupMenu();
                    Set handlers = AppCommRegistry.getInstance().getHandlersForEvent(PatientVariantAnalyzeComm.class);
                    final PatientVariantAnalyzeComm event = new PatientVariantAnalyzeComm(null, Integer.valueOf(PatientView.this.patient.getID()));
                    for (final AppCommHandler handler : handlers) {
                        JMenuItem item = new JMenuItem(handler.getHandlerName());
                        ImageIcon icon = handler.getHandlerIcon();
                        if (icon != null) {
                            int iconSize = 22;
                            Image img = ViewUtil.getScaledInstance(icon.getImage(), iconSize, iconSize, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                            item.setIcon(new ImageIcon(img));
                        }
                        ActionListener l = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                handler.handleCommEvent((Object)event);
                            }
                        };
                        item.addActionListener(l);
                        m.add(item);
                    }
                    m.show(dnaIDButton, 0, (int)dnaIDButton.getSize().getHeight());
                }
            });
        }
        final JButton bamViewButton = ViewUtil.getSoftButton("Open with...");
        if (this.patient.getBamURL() == null || this.patient.getBamURL().isEmpty()) {
            bamViewButton.setEnabled(false);
        } else {
            bamViewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPopupMenu m = new JPopupMenu();
                    Set handlers = AppCommRegistry.getInstance().getHandlersForEvent(BAMFileComm.class);
                    URL u = null;
                    try {
                        u = new URL(PatientView.this.patient.getBamURL());
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                    final BAMFileComm event = new BAMFileComm(null, u);
                    for (final AppCommHandler handler : handlers) {
                        JMenuItem item = new JMenuItem(handler.getHandlerName());
                        ImageIcon icon = handler.getHandlerIcon();
                        if (icon != null) {
                            int iconSize = 22;
                            Image img = ViewUtil.getScaledInstance(icon.getImage(), iconSize, iconSize, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                            item.setIcon(new ImageIcon(img));
                        }
                        ActionListener l = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                handler.handleCommEvent((Object)event);
                            }
                        };
                        item.addActionListener(l);
                        m.add(item);
                    }
                    m.show(bamViewButton, 0, (int)bamViewButton.getSize().getHeight());
                }
            });
        }
        this.profileKVP.setValue(HOSPITAL_ID, (JComponent)individualIDField);
        this.profileKVP.setValue(SEX, (JComponent)sexField);
        this.profileKVP.setValue(AFFECTED, (JComponent)affectedField);
        this.profileKVP.setValue(MOTHER_ID, (JComponent)((Object)motherField));
        this.profileKVP.setValue(FATHER_ID, (JComponent)((Object)fatherField));
        this.profileKVP.setValue(FAMILY_ID, (JComponent)familyIDField);
        this.profileKVP.setAdditionalColumn(FAMILY_ID, 0, pedigree);
        StringEditableField dnaIDField = new StringEditableField();
        dnaIDField.setValue((Object)this.patient.getDnaID());
        dnaIDField.setTag(DNA_ID);
        dnaIDField.setValue((Object)this.patient.getDnaID());
        dnaIDField.addFieldComittedListener((FieldCommittedListener)this);
        StringEditableField bamURLField = new StringEditableField();
        bamURLField.setValidator((EditableFieldValidator)new URLValidator());
        bamURLField.setValue((Object)this.patient.getBamURL());
        bamURLField.setTag(BAM_URL);
        bamURLField.addFieldComittedListener((FieldCommittedListener)this);
        this.geneticsKVP.setValue(DNA_ID, (JComponent)dnaIDField);
        this.geneticsKVP.setAdditionalColumn(DNA_ID, 0, dnaIDButton);
        this.geneticsKVP.setValue(BAM_URL, (JComponent)bamURLField);
        this.geneticsKVP.setAdditionalColumn(BAM_URL, 0, bamViewButton);
        StringEditableField phenotypeField = new StringEditableField();
        phenotypeField.setValue((Object)this.patient.getPhenotypes());
        phenotypeField.setTag(PHENOTYPE);
        phenotypeField.setValue((Object)this.patient.getPhenotypes());
        phenotypeField.addFieldComittedListener((FieldCommittedListener)this);
        this.phenotypeKVP.setValue(PHENOTYPE, (JComponent)phenotypeField);
        try {
            List<Cohort> cohorts = MedSavantClient.PatientManager.getCohortsForPatient(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.patient.getID());
            this.cohortListPanel.removeAll();
            this.cohortListPanel.setLayout((LayoutManager)new MigLayout("wrap, insets 0"));
            if (cohorts.isEmpty()) {
                JLabel noCohortMemberLabel = ViewUtil.getGrayItalicizedLabel("This individual is not in a cohort");
                this.cohortListPanel.add(noCohortMemberLabel);
            } else {
                for (Cohort c : cohorts) {
                    this.cohortListPanel.add(new JLabel(c.getName()));
                }
            }
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateUI();
    }

    public void handleCommitEvent(EditableField f) {
        if (f.getTag().equals(FATHER_ID)) {
            this.patient.setFatherHospitalID((String)f.getValue());
        } else if (f.getTag().equals(MOTHER_ID)) {
            this.patient.setMotherHospitalID((String)f.getValue());
        } else if (f.getTag().equals(FAMILY_ID)) {
            this.patient.setFamilyID((String)f.getValue());
        } else if (f.getTag().equals(AFFECTED)) {
            this.patient.setAffected(((String)f.getValue()).equals("Yes"));
        } else if (f.getTag().equals(HOSPITAL_ID)) {
            this.patient.setHospitalID((String)f.getValue());
        } else if (f.getTag().equals(SEX)) {
            this.patient.setSex((String)f.getValue());
        } else if (f.getTag().equals(DNA_ID)) {
            this.patient.setDnaID((String)f.getValue());
        } else if (f.getTag().equals(BAM_URL)) {
            this.patient.setBamURL((String)f.getValue());
        } else if (f.getTag().equals(PHENOTYPE)) {
            this.patient.setPhenotypes((String)f.getValue());
        }
        this.patient.saveToDatabase();
    }
}

