/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.EnumConstraint;
import org.ut.biolab.medsavant.client.util.FormController;
import org.ut.biolab.medsavant.client.util.RegexpConstraint;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class PatientFormController
extends FormController {
    public PatientFormController() throws SQLException, RemoteException, SessionExpiredException {
        super(MedSavantClient.PatientManager.getPatientFields(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID()), BasicPatientColumns.PATIENT_ID);
        this.initConstraints();
    }

    @Override
    public void submitForm(List<CustomField> fields, List<String> validatedValues) {
        try {
            for (int i = 0; i < validatedValues.size(); ++i) {
                String val = validatedValues.get(i);
                if (!val.trim().isEmpty()) continue;
                validatedValues.remove(i);
                validatedValues.add(i, null);
            }
            MedSavantClient.PatientManager.addPatient(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), fields, validatedValues);
            DialogUtils.displayMessage("Individual Added");
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error adding individual: %s", ex);
        }
    }

    private void initConstraints() {
        this.setConstraint(BasicPatientColumns.BAM_URL, new RegexpConstraint("(?i)^((https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\\s*)+$", BasicPatientColumns.BAM_URL.getColumnLength(), "One or more " + BasicPatientColumns.BAM_URL.getAlias() + " is invalid.  URLs must be entered one per line, and begin with http://"));
        this.setConstraint(BasicPatientColumns.GENDER, new EnumConstraint(new String[][]{{"0", "Undisclosed"}, {"1", "Male"}, {"2", "Female"}}, BasicPatientColumns.GENDER.getColumnLength(), "Invalid Gender: please choose either Male, Female, or Undisclosed"));
        this.setConstraint(BasicPatientColumns.AFFECTED, new EnumConstraint(new String[][]{{"1", "Yes"}, {"0", "No"}}, BasicPatientColumns.AFFECTED.getColumnLength(), "Affected must be set to either Yes or No"));
        this.setRequiredField(BasicPatientColumns.HOSPITAL_ID);
    }
}

