/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class AddPatientsForm
extends JDialog {
    private static final Log LOG = LogFactory.getLog(AddPatientsForm.class);
    private JButton addButton;
    private JButton doneButton;
    private JScrollPane scrollPane;
    private JTable table;
    private JLabel tipLabel;

    public AddPatientsForm() throws RemoteException, SQLException {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.createTable();
        this.setLocationRelativeTo(null);
    }

    private void createTable() throws RemoteException, SQLException {
        this.scrollPane.getViewport().setBackground(Color.white);
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 0;
            }
        };
        model.addColumn("Short Name");
        model.addColumn("Value");
        CustomField[] fields = null;
        try {
            fields = MedSavantClient.PatientManager.getPatientFields(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
        }
        for (int i = 1; i < fields.length; ++i) {
            model.addRow(new Object[]{fields[i], ""});
        }
        this.table.setModel(model);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddPatientsForm.this.setTip();
            }
        });
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    private void setTip() {
        int index = this.table.getSelectedRow();
        Object o = this.table.getValueAt(index, 0);
        if (o != null) {
            CustomField f = (CustomField)o;
            String s = f.getAlias() + " | " + f.getColumnType().toString().toLowerCase();
            switch (f.getColumnType()) {
                case DATE: {
                    s = s + "(yyyy-mm-dd)";
                    break;
                }
                case BOOLEAN: {
                    s = s + "(true/false)";
                }
            }
            this.tipLabel.setText(s);
        }
    }

    private void addPatient() throws SQLException, RemoteException {
        int i;
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<CustomField> cols = new ArrayList<CustomField>();
        for (i = 0; i < this.table.getRowCount(); ++i) {
            String value = (String)this.table.getModel().getValueAt(i, 1);
            if (value == null || value.equals("")) continue;
            cols.add((CustomField)this.table.getModel().getValueAt(i, 0));
            values.add((String)this.table.getModel().getValueAt(i, 1));
        }
        for (i = 0; i < values.size(); ++i) {
            values.set(i, ((String)values.get(i)).equals("") ? null : (String)values.get(i));
        }
        try {
            MedSavantClient.PatientManager.addPatient(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), cols, values);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
        }
        this.clearTable();
    }

    private void clearTable() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.table.getModel().setValueAt("", i, 1);
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.addButton = new JButton();
        JLabel jLabel1 = new JLabel();
        this.doneButton = new JButton();
        this.tipLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Patients");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.scrollPane.setViewportView(this.table);
        this.addButton.setText("Add Individual");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPatientsForm.this.addButtonActionPerformed(evt);
            }
        });
        jLabel1.setFont(new Font("Tahoma", 1, 11));
        jLabel1.setText("Add Single Patient:");
        this.doneButton.setText("Done");
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPatientsForm.this.doneButtonActionPerformed(evt);
            }
        });
        this.tipLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.tipLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.doneButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -2, 283, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.tipLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doneButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void doneButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        try {
            this.addPatient();
            DialogUtils.displayMessage("Individual Added");
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error adding individual: %s", ex);
        }
    }
}

