/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.clinic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.clinic.GalleryItem;
import org.ut.biolab.medsavant.client.view.component.WrapLayout;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class GalleryView
extends JPanel {
    private JPanel carousel;
    private int itemSize = 128;
    private final String title;
    private final JPanel menuCard;
    private final JPanel content;
    private final JLabel titleLabel;
    private final JButton menuButton;
    private final JPanel footer;

    public GalleryView(String title, String backButtonText, String bottomText) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.title = title;
        JPanel banner = ViewUtil.getTertiaryBannerPanel();
        this.titleLabel = ViewUtil.getTitleLabel(title);
        this.menuButton = new JButton(backButtonText);
        this.menuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GalleryView.this.goToMenu();
            }
        });
        banner.add(this.titleLabel);
        JPanel left = ViewUtil.getClearPanel();
        this.fixSizeTo(left, 100, 25);
        ViewUtil.applyHorizontalBoxLayout(left);
        left.add(this.menuButton);
        JPanel right = ViewUtil.getClearPanel();
        this.fixSizeTo(right, 100, 25);
        banner.add(left);
        banner.add(Box.createHorizontalGlue());
        banner.add(this.titleLabel);
        banner.add(Box.createHorizontalGlue());
        banner.add(right);
        this.content = ViewUtil.getClearPanel();
        this.content.setLayout(new BorderLayout());
        this.add((Component)banner, "North");
        this.add((Component)this.content, "Center");
        this.footer = ViewUtil.centerHorizontally(new JLabel(bottomText));
        this.footer.setBorder(ViewUtil.getMediumBorder());
        this.add((Component)this.footer, "South");
        this.menuCard = this.getMenuCard();
        this.goToMenu();
    }

    public void setMenuHeroPanel(JPanel heroPanel) {
        this.menuCard.add((Component)ViewUtil.centerHorizontally(heroPanel), "North");
    }

    private JPanel getMenuCard() {
        JPanel p = new JPanel();
        p.setBackground(Color.white);
        p.setLayout(new BorderLayout());
        this.carousel = ViewUtil.getClearPanel();
        p.add((Component)ViewUtil.getClearBorderlessScrollPane(this.carousel), "Center");
        return p;
    }

    public void setGalleryItems(List<GalleryItem> galleryItems) {
        this.carousel.removeAll();
        this.carousel.setVisible(false);
        this.carousel.setLayout(new WrapLayout(1, 10, 5));
        for (final GalleryItem g : galleryItems) {
            ImageIcon icon = g.getIcon();
            icon = this.resizeIconTo(icon, this.itemSize);
            JButton b = ViewUtil.getIconButton(icon);
            this.carousel.add(ViewUtil.subTextComponent(b, g.getName(), 16));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GalleryView.this.setContentTo(g.getPanel(), g.getName());
                }
            });
            b.setCursor(new Cursor(12));
        }
        this.carousel.setVisible(true);
        this.carousel.getParent().invalidate();
        this.carousel.invalidate();
        this.carousel.updateUI();
    }

    private ImageIcon resizeIconTo(ImageIcon icon, int itemSize) {
        Image img = icon.getImage();
        Image newimg = img.getScaledInstance(itemSize, itemSize, 4);
        return new ImageIcon(newimg);
    }

    private void setContentTo(JPanel p, String title) {
        this.menuButton.setVisible(p != this.menuCard);
        this.footer.setVisible(p == this.menuCard);
        this.content.removeAll();
        this.content.add((Component)p, "Center");
        this.titleLabel.setText(title);
        this.content.updateUI();
    }

    private void goToMenu() {
        this.setContentTo(this.menuCard, this.title);
    }

    private void fixSizeTo(JPanel p, int w, int h) {
        Dimension d = new Dimension(w, h);
        p.setMinimumSize(d);
        p.setPreferredSize(d);
        p.setMaximumSize(d);
    }
}

