/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app.page;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;
import org.ut.biolab.medsavant.client.app.AppInfo;
import org.ut.biolab.medsavant.client.app.AppInstallUtils;
import org.ut.biolab.medsavant.client.app.AppStorePage;
import org.ut.biolab.medsavant.client.app.api.AppInfoFetcher;
import org.ut.biolab.medsavant.client.app.api.AppInstaller;
import org.ut.biolab.medsavant.client.app.page.AppInfoFlowView;
import org.ut.biolab.medsavant.client.app.page.AppStoreInstalledPage;
import org.ut.biolab.medsavant.client.plugin.AppDescriptor;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.app.AppDirectory;
import org.ut.biolab.medsavant.client.view.component.LazyPanel;
import org.ut.biolab.medsavant.client.view.notify.Notification;
import org.ut.biolab.medsavant.client.view.util.StandardAppContainer;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class AppStoreLandingPage
implements AppStorePage {
    private final AppStoreInstalledPage installedPage;
    private final AppInfoFetcher fetcher;
    private JPanel appListView;
    private final JTabbedPane parent;
    private final AppInstaller installer;

    public AppStoreLandingPage(AppInfoFetcher fetcher, AppInstaller installer, JTabbedPane parent, AppStoreInstalledPage installedPage) {
        this.fetcher = fetcher;
        this.installer = installer;
        this.parent = parent;
        this.installedPage = installedPage;
    }

    @Override
    public String getName() {
        return "Apps";
    }

    @Override
    public LazyPanel getView() {
        LazyPanel p = new LazyPanel(){

            @Override
            public void viewDidLoad() {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            final List<AppInfo> appInfo = AppStoreLandingPage.this.fetcher.fetchApplicationInformation(null);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    AppStoreLandingPage.this.setAppInfo(appInfo);
                                }
                            });
                        }
                        catch (Exception ex) {
                            Logger.getLogger(AppStoreLandingPage.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
                t.start();
            }

            @Override
            public void viewDidUnload() {
            }
        };
        p.setOpaque(false);
        p.setLayout(new BorderLayout());
        JPanel container = ViewUtil.getClearPanel();
        container.setLayout((LayoutManager)new MigLayout("fillx,insets 0"));
        this.appListView = ViewUtil.getClearPanel();
        this.appListView.setLayout((LayoutManager)new MigLayout("wrap, fillx, insets 0"));
        JLabel titleLabel = ViewUtil.getLargeSerifLabel("Available Apps");
        JButton appFromFile = new JButton("Install app from file...");
        appFromFile.addActionListener(this.getAppFromFileAL());
        container.add((Component)titleLabel, "wrap");
        container.add((Component)appFromFile, "wrap");
        container.add((Component)this.appListView, "growx 1.0");
        JPanel fixedWidth = ViewUtil.getDefaultFixedWidthPanel(container);
        StandardAppContainer sac = new StandardAppContainer(fixedWidth);
        p.add((Component)sac, "Center");
        sac.setBackground(ViewUtil.getLightGrayBackgroundColor());
        return p;
    }

    private synchronized void setAppInfo(List<AppInfo> info) {
        this.appListView.removeAll();
        Set<AppInfo> installRegistry = this.installer.getInstallRegistry();
        for (AppInfo i : info) {
            boolean installedAlready = installRegistry.contains(i);
            boolean canUpdate = false;
            if (installedAlready) {
                AppInfo installedApp = AppInstallUtils.getAppWithName(this.installer, i.getName());
                if (new AppDescriptor.AppVersion(i.getVersion()).isNewerThan(new AppDescriptor.AppVersion(installedApp.getVersion()))) {
                    canUpdate = true;
                }
            }
            AppInfoFlowView infoBox = new AppInfoFlowView(i, this.parent, this.installedPage, installedAlready, canUpdate);
            this.appListView.add((Component)infoBox, "width 100%");
        }
        this.appListView.updateUI();
    }

    private ActionListener getAppFromFileAL() {
        ActionListener outputAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("JAR file", "jar");
                chooser.setFileFilter(filter);
                int chooserValue = chooser.showOpenDialog(MedSavantFrame.getInstance());
                if (chooserValue == 0) {
                    File chooserFile = new File(chooser.getSelectedFile().getPath());
                    try {
                        FileUtils.copyFileToDirectory((File)chooserFile, (File)new File(DirectorySettings.getPluginsDirectory().getAbsolutePath()));
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                Notification n = new Notification();
                n.setIcon(AppDirectory.getAppStore().getIcon());
                n.setName("App installed");
                n.setDescription("Restart to complete installation");
                MedSavantFrame.getInstance().showNotification(n);
                n.setAction("Restart", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MedSavantFrame.getInstance().requestLogoutAndRestart();
                    }
                });
            }
        };
        return outputAL;
    }
}

