/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app.page;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.app.AppInfo;
import org.ut.biolab.medsavant.client.app.AppInstallUtils;
import org.ut.biolab.medsavant.client.app.AppStorePage;
import org.ut.biolab.medsavant.client.app.api.AppInstaller;
import org.ut.biolab.medsavant.client.app.page.AppInstallInstalledView;
import org.ut.biolab.medsavant.client.app.page.AppInstallProgressView;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.app.AppDirectory;
import org.ut.biolab.medsavant.client.view.component.LazyPanel;
import org.ut.biolab.medsavant.client.view.notify.Notification;
import org.ut.biolab.medsavant.client.view.util.StandardAppContainer;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class AppStoreInstalledPage
implements AppStorePage {
    AppInstaller installer;
    private final HashSet<AppInfo> installQueue;
    private final LazyPanel view;
    private final HashSet<AppInfo> recentlyInstalled;
    private final HashSet<AppInfo> recentlyUninstalled;

    public AppStoreInstalledPage(AppInstaller installer) {
        this.installer = installer;
        this.installQueue = new HashSet();
        this.view = new LazyPanel(){

            @Override
            public void viewDidLoad() {
                AppStoreInstalledPage.this.updateInstalledList();
            }

            @Override
            public void viewDidUnload() {
            }
        };
        this.view.setOpaque(false);
        this.recentlyInstalled = new HashSet();
        this.recentlyUninstalled = new HashSet();
    }

    @Override
    public String getName() {
        return "Installed";
    }

    @Override
    public LazyPanel getView() {
        return this.view;
    }

    protected void updateInstalledList() {
        JLabel queuedTitle;
        this.view.removeAll();
        this.view.setLayout(new BorderLayout());
        JPanel container = ViewUtil.getClearPanel();
        MigLayout ml = new MigLayout("wrap 1, gapy 5, hidemode 3, insets 0");
        container.setLayout((LayoutManager)ml);
        if (!this.installQueue.isEmpty()) {
            queuedTitle = ViewUtil.getLargeGrayLabel("Installing...");
            container.add(queuedTitle);
            for (AppInfo i : this.installQueue) {
                container.add((Component)new AppInstallProgressView(i), "width 100%");
            }
            container.add(Box.createVerticalStrut(20));
        }
        queuedTitle = ViewUtil.getLargeSerifLabel("Installed");
        container.add(queuedTitle);
        Set<AppInfo> installedApps = this.installer.getInstallRegistry();
        for (AppInfo i : installedApps) {
            if (this.recentlyInstalled.contains(i) || this.recentlyUninstalled.contains(i)) continue;
            container.add((Component)new AppInstallInstalledView(i, this.installer, this, AppInstallInstalledView.State.INSTALLED), "width 100%");
        }
        for (AppInfo i : this.recentlyInstalled) {
            container.add((Component)new AppInstallInstalledView(i, this.installer, this, AppInstallInstalledView.State.JUST_INSTALLED), "width 100%");
        }
        for (AppInfo i : this.recentlyUninstalled) {
            container.add((Component)new AppInstallInstalledView(i, this.installer, this, AppInstallInstalledView.State.JUST_UNINSTALLED), "width 100%");
        }
        if (installedApps.isEmpty()) {
            container.add(ViewUtil.getGrayItalicizedLabel("No apps installed"));
        }
        if (!this.recentlyInstalled.isEmpty() || !this.recentlyUninstalled.isEmpty()) {
            container.add(Box.createVerticalStrut(5));
            JButton restartButton = new JButton("Restart Now");
            restartButton.addActionListener(this.installer.getRestartActionListener());
            container.add(ViewUtil.horizontallyAlignComponents(new Component[]{new JLabel("<html><font color=RED>Restart " + this.installer.getProgramName() + " for changes to take effect</font></html>"), restartButton}));
        }
        JPanel fixedWidth = ViewUtil.getDefaultFixedWidthPanel(container);
        StandardAppContainer sac = new StandardAppContainer(fixedWidth);
        this.view.add((Component)sac, "Center");
        sac.setBackground(ViewUtil.getLightGrayBackgroundColor());
        this.view.updateUI();
    }

    private synchronized void dequeueAppForInstallation(AppInfo i) {
        this.installQueue.remove(i);
    }

    synchronized void queueAppForInstallation(AppInfo i) {
        this.queueAppForInstallation(i, true);
    }

    synchronized void queueAppForInstallation(final AppInfo i, boolean async) {
        System.out.println("Installing " + i.toString());
        if (!this.recentlyUninstalled.contains(i) && (this.installer.getInstallRegistry().contains(i) || this.installQueue.contains(i))) {
            System.out.println("App already installed, stopping");
            return;
        }
        this.installQueue.add(i);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Notification n = new Notification();
                n.setName("Installing " + i.getName());
                n.setIsIndeterminateProgress(true);
                n.setIcon(AppDirectory.getAppStore().getIcon());
                n.setShowsProgress(true);
                MedSavantFrame.getInstance().showNotification(n);
                boolean success = AppStoreInstalledPage.this.installer.installApp(i);
                if (success) {
                    AppStoreInstalledPage.this.addRecentlyInstalledApp(i);
                    AppStoreInstalledPage.this.dequeueAppForInstallation(i);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppStoreInstalledPage.this.updateInstalledList();
                        }
                    });
                    n.setDescription("Installed. Requires restart.");
                    n.setShowsProgress(false);
                    n.setAction("Restart", new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MedSavantFrame.getInstance().requestLogoutAndRestart();
                        }
                    });
                } else {
                    n.setDescription("Error installing App");
                    n.setShowsProgress(false);
                }
                n.setIsIndeterminateProgress(false);
            }
        });
        t.start();
        if (!async) {
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    synchronized void queueAppWithNameForUninstallation(String name) {
        this.queueAppWithNameForUninstallation(name, true);
    }

    synchronized void queueAppWithNameForUninstallation(String name, boolean async) {
        final AppInfo i = AppInstallUtils.getAppWithName(this.installer, name);
        if (i == null || !this.installer.getInstallRegistry().contains(i)) {
            return;
        }
        final AppStoreInstalledPage thisInstance = this;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean success = AppStoreInstalledPage.this.installer.uninstallApp(i);
                if (success) {
                    thisInstance.addRecentlyUninstalledApp(i);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            thisInstance.updateInstalledList();
                        }
                    });
                }
            }
        });
        t.start();
        if (!async) {
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    public void addRecentlyUninstalledApp(AppInfo i) {
        this.recentlyUninstalled.add(i);
    }

    public void addRecentlyInstalledApp(AppInfo i) {
        this.recentlyInstalled.add(i);
    }
}

