/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app.page;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.app.AppInfo;
import org.ut.biolab.medsavant.client.app.api.AppInstaller;
import org.ut.biolab.medsavant.client.app.jAppStore;
import org.ut.biolab.medsavant.client.app.page.AppInfoFlowView;
import org.ut.biolab.medsavant.client.app.page.AppStoreInstalledPage;

class AppInstallInstalledView
extends JPanel {
    private final AppInfo appInfo;
    private final AppInstaller installer;
    private final AppStoreInstalledPage installPage;
    private final State state;

    public AppInstallInstalledView(AppInfo i, AppInstaller installer, AppStoreInstalledPage parent, State state) {
        this.appInfo = i;
        this.installer = installer;
        this.installPage = parent;
        this.state = state;
        this.setBackground(Color.white);
        int padding = 10;
        this.setBorder(BorderFactory.createEmptyBorder(padding, padding, padding, padding));
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel("<html><b>" + i.getName() + "</b> " + i.getVersion() + "</html>"));
        this.add((Component)this.getUninstallButton(state), "right");
        jAppStore.wrapComponentWithLineBorder(this);
    }

    private JButton getUninstallButton(State state) {
        JButton b = AppInfoFlowView.getSoftButton("Uninstall");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AppInstallInstalledView.this.installPage.queueAppWithNameForUninstallation(AppInstallInstalledView.this.appInfo.getName());
            }
        });
        switch (state) {
            case INSTALLED: {
                break;
            }
            case JUST_INSTALLED: {
                b.setEnabled(false);
                b.setText("Installed");
                break;
            }
            case JUST_UNINSTALLED: {
                b.setEnabled(false);
                b.setText("Uninstalled");
                break;
            }
            default: {
                throw new AssertionError((Object)state.name());
            }
        }
        return b;
    }

    static enum State {
        JUST_INSTALLED,
        JUST_UNINSTALLED,
        INSTALLED;

    }
}

