/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ut.biolab.medsavant.client.app.AppInfo;
import org.ut.biolab.medsavant.client.app.api.AppInstaller;
import org.ut.biolab.medsavant.client.plugin.AppController;
import org.ut.biolab.medsavant.client.plugin.AppDescriptor;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.shared.util.NetworkUtils;

public class MedSavantAppInstaller
implements AppInstaller {
    private HashSet<AppInfo> installedApps;

    @Override
    public boolean installApp(AppInfo i) {
        System.out.println("Installing app " + i.getName());
        String url = i.getDownloadURL().getFile();
        System.out.println("Downloading from " + i.getDownloadURL().toString());
        String fileName = url.substring(url.lastIndexOf(47) + 1, url.length());
        try {
            System.out.println("Downloading to " + DirectorySettings.getTmpDirectory().getAbsolutePath());
            File downloadedFile = NetworkUtils.downloadFile(i.getDownloadURL(), DirectorySettings.getTmpDirectory(), fileName);
            System.out.println("Downloaded " + downloadedFile.getAbsolutePath());
            System.out.println("Installing from " + downloadedFile.getAbsolutePath());
            AppController.getInstance().installPlugin(downloadedFile);
            System.out.println("Plugin installed to  " + DirectorySettings.getPluginsDirectory().getAbsolutePath());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
        System.out.println("Done installing app " + i.getName());
        return true;
    }

    private void updateRegistry() {
        this.installedApps = new HashSet();
        List<AppDescriptor> descriptors = AppController.getInstance().getDescriptors();
        for (AppDescriptor pd : descriptors) {
            String name = pd.getName();
            String version = pd.getVersion();
            String category = pd.getCategory().toString();
            String sdkVersion = pd.getSDKVersion();
            AppInfo ai = new AppInfo(name, version, category, sdkVersion, null, null, null, null, null, null);
            ai.setID(pd.getID());
            this.installedApps.add(ai);
        }
    }

    @Override
    public Set<AppInfo> getInstallRegistry() {
        this.updateRegistry();
        return this.installedApps;
    }

    @Override
    public boolean uninstallApp(AppInfo appInfo) {
        System.out.println("Uninstalling app " + appInfo.toString());
        return AppController.getInstance().queuePluginForRemoval(appInfo.getID());
    }

    @Override
    public String getProgramName() {
        return "MedSavant";
    }

    @Override
    public ActionListener getRestartActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedSavantFrame.getInstance().requestLogoutAndRestart();
            }
        };
    }
}

