/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.utils.Lm;
import gnu.getopt.Getopt;
import java.awt.Color;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.NoRouteToHostException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalIconFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.controller.SettingsController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.util.ServerModificationInvocationHandler;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.font.FontFactory;
import org.ut.biolab.medsavant.client.view.login.SplashFrame;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.exception.LockException;
import org.ut.biolab.medsavant.shared.serverapi.AnnotationManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.CohortManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.CustomTablesAdapter;
import org.ut.biolab.medsavant.shared.serverapi.DBUtilsAdapter;
import org.ut.biolab.medsavant.shared.serverapi.GeneSetManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.LogManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.MedSavantServerRegistry;
import org.ut.biolab.medsavant.shared.serverapi.NetworkManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.NotificationManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.OntologyManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.PatientManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.ProjectManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.ReferenceManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.RegionSetManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.SessionManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.SettingsManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.SetupAdapter;
import org.ut.biolab.medsavant.shared.serverapi.UserManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.VariantManagerAdapter;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import org.ut.biolab.medsavant.shared.util.VersionSettings;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;

public class MedSavantClient
implements MedSavantServerRegistry {
    private static final Log LOG = LogFactory.getLog(MedSavantClient.class);
    public static CustomTablesAdapter CustomTablesManager;
    public static AnnotationManagerAdapter AnnotationManagerAdapter;
    public static CohortManagerAdapter CohortManager;
    public static GeneSetManagerAdapter GeneSetManager;
    public static LogManagerAdapter LogManager;
    public static NetworkManagerAdapter NetworkManager;
    public static OntologyManagerAdapter OntologyManager;
    public static PatientManagerAdapter PatientManager;
    public static ProjectManagerAdapter ProjectManager;
    public static UserManagerAdapter UserManager;
    public static SessionManagerAdapter SessionManager;
    public static SettingsManagerAdapter SettingsManager;
    public static RegionSetManagerAdapter RegionSetManager;
    public static ReferenceManagerAdapter ReferenceManager;
    public static DBUtilsAdapter DBUtils;
    public static SetupAdapter SetupManager;
    public static VariantManagerAdapter VariantManager;
    public static NotificationManagerAdapter NotificationManager;
    private static boolean initialized;
    private static String[] restartCommand;
    private static boolean restarting;
    private static final Object managerLock;

    private static void initProxies() {
        VariantManager = (VariantManagerAdapter)Proxy.newProxyInstance(VariantManager.getClass().getClassLoader(), new Class[]{VariantManagerAdapter.class}, new ServerModificationInvocationHandler<VariantManagerAdapter>(VariantManager));
        CohortManager = (CohortManagerAdapter)Proxy.newProxyInstance(CohortManager.getClass().getClassLoader(), new Class[]{CohortManagerAdapter.class}, new ServerModificationInvocationHandler<CohortManagerAdapter>(CohortManager));
        PatientManager = (PatientManagerAdapter)Proxy.newProxyInstance(PatientManager.getClass().getClassLoader(), new Class[]{PatientManagerAdapter.class}, new ServerModificationInvocationHandler<PatientManagerAdapter>(PatientManager));
        RegionSetManager = (RegionSetManagerAdapter)Proxy.newProxyInstance(RegionSetManager.getClass().getClassLoader(), new Class[]{RegionSetManagerAdapter.class}, new ServerModificationInvocationHandler<RegionSetManagerAdapter>(RegionSetManager));
        OntologyManager = (OntologyManagerAdapter)Proxy.newProxyInstance(OntologyManager.getClass().getClassLoader(), new Class[]{OntologyManagerAdapter.class}, new ServerModificationInvocationHandler<OntologyManagerAdapter>(OntologyManager));
    }

    public static void restart() {
        if (!restarting) {
            restarting = true;
            try {
                SettingsController.getInstance().setBoolean("BootFromLogout", true);
                System.out.println("Restarting with " + restartCommand[0]);
                Runtime.getRuntime().exec(restartCommand);
                System.exit(0);
            }
            catch (IOException e) {
                DialogUtils.displayError("Error restarting MedSavant. Please restart MedSavant manually.");
                LOG.error((Object)e);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public static void setRestartCommand(String[] args) {
        ArrayList<String> restartCommandList = new ArrayList<String>();
        String launcher = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        restartCommandList.add(launcher);
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            restartCommandList.add(jvmArg);
        }
        restartCommandList.add("-cp");
        restartCommandList.add(ManagementFactory.getRuntimeMXBean().getClassPath());
        restartCommandList.add(MedSavantClient.class.getName());
        for (String arg : args) {
            restartCommandList.add(arg);
        }
        restartCommand = restartCommandList.toArray(new String[restartCommandList.size()]);
    }

    public static void checkJavaVersion() {
        System.out.println(System.getProperty("java.specification.version"));
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.equals("1.7") || javaVersion.equals("1.8")) {
            return;
        }
        DialogUtils.displayError("Incompatible Java Version", "Please upgrade your version of Java to 1.7 or greater.");
        System.exit(1);
    }

    public static void main(String[] args) {
        int c;
        new MedSavantWorker<Void>("Analytics Start"){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    AnalyticsAgent.onStartSession((String)"MedSavant", (String)VersionSettings.getVersionString());
                }
                catch (Exception ex) {
                    LOG.error((Object)"Couldn't connect to analytics agent.");
                }
                return null;
            }

            @Override
            protected void showSuccess(Void result) {
            }
        }.execute();
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        MedSavantClient.setRestartCommand(args);
        MedSavantClient.setExceptionHandler();
        MedSavantClient.verifyJIDE();
        MedSavantClient.setLAF();
        SettingsController.getInstance();
        Getopt g = new Getopt("MedSavant", args, "h:p:d:u:w:");
        block8: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 104: {
                    String host = g.getOptarg();
                    SettingsController.getInstance().setServerAddress(host);
                    continue block8;
                }
                case 112: {
                    int port = Integer.parseInt(g.getOptarg());
                    SettingsController.getInstance().setServerPort(port + "");
                    continue block8;
                }
                case 100: {
                    String dbname = g.getOptarg();
                    SettingsController.getInstance().setDBName(dbname);
                    continue block8;
                }
                case 117: {
                    String username = g.getOptarg();
                    SettingsController.getInstance().setUsername(username);
                    continue block8;
                }
                case 119: {
                    String password = g.getOptarg();
                    SettingsController.getInstance().setPassword(password);
                    continue block8;
                }
                case 63: {
                    continue block8;
                }
            }
            System.out.print("getopt() returned " + c + "\n");
        }
        String username = System.getProperty("user.name");
        DirectorySettings.setTmpDirectory(new File(System.getProperty("java.io.tmpdir"), "msavant_" + username).getAbsolutePath());
        DirectorySettings.setMedSavantDirectory(new File(System.getProperty("user.home"), MiscUtils.WINDOWS ? "medsavant" : ".medsavant").getAbsolutePath());
        LOG.info((Object)"MedSavant booted");
        System.out.println("READY.");
        SplashFrame loginFrame = new SplashFrame();
        loginFrame.setVisible(true);
    }

    public static void initializeRegistry(String serverAddress, String serverPort) throws RemoteException, NotBoundException, NoRouteToHostException, ConnectIOException {
        block3: {
            if (initialized) {
                return;
            }
            int port = new Integer(serverPort);
            LOG.debug((Object)("Connecting to MedSavantServerEngine @ " + serverAddress + ":" + serverPort + "..."));
            try {
                Registry registry = LocateRegistry.getRegistry(serverAddress, port, new SslRMIClientSocketFactory());
                LOG.debug((Object)"Retrieving adapters...");
                MedSavantClient.setAdaptersFromRegistry(registry);
                LOG.info((Object)"Connected with SSL/TLS Encryption");
            }
            catch (ConnectIOException ex) {
                if (!(ex.getCause() instanceof SSLHandshakeException)) break block3;
                Registry registry = LocateRegistry.getRegistry(serverAddress, port);
                LOG.debug((Object)"Retrieving adapters...");
                MedSavantClient.setAdaptersFromRegistry(registry);
                LOG.info((Object)"Connected without SSL/TLS encryption");
            }
        }
        LOG.debug((Object)"Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAdaptersFromRegistry(Registry registry) throws RemoteException, NotBoundException, NoRouteToHostException, ConnectIOException {
        AnnotationManagerAdapter AnnotationManagerAdapter2 = (AnnotationManagerAdapter)registry.lookup("AnnotationManager");
        CohortManagerAdapter CohortManager = (CohortManagerAdapter)registry.lookup("CohortManager");
        LogManagerAdapter LogManager2 = (LogManagerAdapter)registry.lookup("LogManager");
        NetworkManagerAdapter NetworkManager = (NetworkManagerAdapter)registry.lookup("NetworkManager");
        OntologyManagerAdapter OntologyManager = (OntologyManagerAdapter)registry.lookup("OntologyManager");
        PatientManagerAdapter PatientManager = (PatientManagerAdapter)registry.lookup("PatientManager");
        ProjectManagerAdapter ProjectManager = (ProjectManagerAdapter)registry.lookup("ProjectManager");
        GeneSetManagerAdapter GeneSetManager = (GeneSetManagerAdapter)registry.lookup("GeneSetManager");
        ReferenceManagerAdapter ReferenceManager = (ReferenceManagerAdapter)registry.lookup("ReferenceManager");
        RegionSetManagerAdapter RegionSetManager = (RegionSetManagerAdapter)registry.lookup("RegionSetManager");
        SessionManagerAdapter SessionManager = (SessionManagerAdapter)registry.lookup("SessionManager");
        SettingsManagerAdapter SettingsManager = (SettingsManagerAdapter)registry.lookup("SettingsManager");
        UserManagerAdapter UserManager = (UserManagerAdapter)registry.lookup("UserManager");
        VariantManagerAdapter VariantManager = (VariantManagerAdapter)registry.lookup("VariantManager");
        DBUtilsAdapter DBUtils = (DBUtilsAdapter)registry.lookup("DBUtilManager");
        SetupAdapter SetupManager = (SetupAdapter)registry.lookup("SetupManager");
        CustomTablesAdapter CustomTablesManager = (CustomTablesAdapter)registry.lookup("CustomTablesManager");
        NotificationManagerAdapter NotificationManager = (NotificationManagerAdapter)registry.lookup("NotificationManager");
        if (Thread.interrupted()) {
            return;
        }
        Object object = managerLock;
        synchronized (object) {
            MedSavantClient.CustomTablesManager = CustomTablesManager;
            AnnotationManagerAdapter = AnnotationManagerAdapter2;
            MedSavantClient.CohortManager = CohortManager;
            MedSavantClient.GeneSetManager = GeneSetManager;
            LogManager = LogManager2;
            MedSavantClient.NetworkManager = NetworkManager;
            MedSavantClient.OntologyManager = OntologyManager;
            MedSavantClient.PatientManager = PatientManager;
            MedSavantClient.ProjectManager = ProjectManager;
            MedSavantClient.UserManager = UserManager;
            MedSavantClient.SessionManager = SessionManager;
            MedSavantClient.SettingsManager = SettingsManager;
            MedSavantClient.RegionSetManager = RegionSetManager;
            MedSavantClient.ReferenceManager = ReferenceManager;
            MedSavantClient.DBUtils = DBUtils;
            MedSavantClient.SetupManager = SetupManager;
            MedSavantClient.VariantManager = VariantManager;
            MedSavantClient.NotificationManager = NotificationManager;
            MedSavantClient.initProxies();
        }
    }

    private static void setLAF() {
        try {
            if (ClientMiscUtils.MAC) {
                MedSavantClient.customizeForMac();
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                LOG.debug((Object)("Installed LAF: " + info.getName() + " class: " + info.getClassName()));
            }
            LOG.debug((Object)("System LAF is: " + UIManager.getSystemLookAndFeelClassName()));
            LOG.debug((Object)("Cross platform LAF is: " + UIManager.getCrossPlatformLookAndFeelClassName()));
            LookAndFeelFactory.addUIDefaultsInitializer((LookAndFeelFactory.UIDefaultsInitializer)new LookAndFeelFactory.UIDefaultsInitializer(){

                public void initialize(UIDefaults defaults) {
                    HashMap<String, Object> defaultValues = new HashMap<String, Object>();
                    defaultValues.put("Slider.trackWidth", new Integer(7));
                    defaultValues.put("Slider.majorTickLength", new Integer(6));
                    defaultValues.put("Slider.highlight", new ColorUIResource(255, 255, 255));
                    defaultValues.put("Slider.horizontalThumbIcon", MetalIconFactory.getHorizontalSliderThumbIcon());
                    defaultValues.put("Slider.verticalThumbIcon", MetalIconFactory.getVerticalSliderThumbIcon());
                    defaultValues.put("Slider.focusInsets", new InsetsUIResource(0, 0, 0, 0));
                    for (Map.Entry e : defaultValues.entrySet()) {
                        if (defaults.get(e.getKey()) == null) {
                            LOG.debug((Object)("Missing key " + (String)e.getKey() + ", using default value " + e.getValue()));
                            defaults.put(e.getKey(), e.getValue());
                            continue;
                        }
                        LOG.debug((Object)("Found key " + (String)e.getKey() + " with value " + defaults.get(e.getKey())));
                    }
                }
            });
            if (MiscUtils.WINDOWS) {
                UIManager.put("CheckBox.background", new ColorUIResource(Color.WHITE));
                UIManager.put("Panel.background", new ColorUIResource(Color.WHITE));
                LookAndFeelFactory.installJideExtension((int)6);
            } else {
                LookAndFeelFactory.installJideExtension();
            }
            LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
            UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
            UIManager.put("ToolTip.background", new ColorUIResource(255, 255, 255));
            ToolTipManager.sharedInstance().setDismissDelay(8000);
            ToolTipManager.sharedInstance().setInitialDelay(500);
        }
        catch (Exception x) {
            LOG.error((Object)"Unable to install look & feel.", (Throwable)x);
        }
    }

    private static void customizeForMac() {
        try {
            UIManager.put("Panel.background", new Color(237, 237, 237));
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "MedSavant");
            MedSavantClient.batchApplyProperty(new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font", "JOptionPane.font", "JDialog.font"}, FontFactory.getGeneralFont());
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
            UIManager.put("TitledBorder.border", UIManager.getBorder("TitledBorder.aquaVariant"));
            Application macOSXApplication = Application.getApplication();
            macOSXApplication.setAboutHandler(new AboutHandler(){

                public void handleAbout(AppEvent.AboutEvent evt) {
                    JOptionPane.showMessageDialog(MedSavantFrame.getInstance(), "MedSavant " + VersionSettings.getVersionString() + "\nCreated by Biolab at University of Toronto.");
                }
            });
            macOSXApplication.setPreferencesHandler(new PreferencesHandler(){

                public void handlePreferences(AppEvent.PreferencesEvent pe) {
                    DialogUtils.displayMessage("Preferences available for Administrators only");
                }
            });
            macOSXApplication.setQuitHandler(new QuitHandler(){

                public void handleQuitRequestWith(AppEvent.QuitEvent evt, QuitResponse resp) {
                    MedSavantFrame.getInstance().requestClose();
                    resp.cancelQuit();
                }
            });
        }
        catch (Throwable x) {
            System.err.println("Warning: MedSavant requires Java for Mac OS X 10.6 Update 3 (or later).\nPlease check Software Update for the latest version.");
        }
    }

    private static void batchApplyProperty(String[] propn, Object o) {
        for (String s : propn) {
            UIManager.put(s, o);
        }
    }

    private static void verifyJIDE() {
        Lm.verifyLicense((String)"Marc Fiume", (String)"Savant Genome Browser", (String)"1BimsQGmP.vjmoMbfkPdyh0gs3bl3932");
    }

    private static void setExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.info((Object)("Global exception handler caught: " + t.getName() + ": " + e));
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getCause();
                }
                if (e instanceof SessionExpiredException) {
                    SessionExpiredException see = (SessionExpiredException)e;
                    MedSavantExceptionHandler.handleSessionExpiredException(see);
                    return;
                }
                if (e instanceof LockException) {
                    DialogUtils.displayMessage("Cannot modify database", "<html>Another process is making changes.<br/>Please try again later.</html>");
                    return;
                }
                e.printStackTrace();
                DialogUtils.displayException("Error", e.getLocalizedMessage(), e);
            }
        });
    }

    static {
        initialized = false;
        restarting = false;
        managerLock = new Object();
    }
}

