/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GeneManiaStringUtils {
    private static Logger LOG = Logger.getLogger(GeneManiaStringUtils.class);
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private static final String CR = "\n";
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";

    public static String extractSeparator(String text) {
        String ret = SPACE;
        Hashtable<String, Integer> separatorsMap = new Hashtable<String, Integer>();
        separatorsMap.put(SPACE, StringUtils.countMatches((String)text, (String)SPACE));
        separatorsMap.put(TAB, StringUtils.countMatches((String)text, (String)TAB));
        separatorsMap.put(CR, StringUtils.countMatches((String)text, (String)CR));
        separatorsMap.put(COMMA, StringUtils.countMatches((String)text, (String)COMMA));
        separatorsMap.put(SEMICOLON, StringUtils.countMatches((String)text, (String)SEMICOLON));
        Enumeration separators = separatorsMap.keys();
        int maxCount = 0;
        while (separators.hasMoreElements()) {
            String nextSeparator = (String)separators.nextElement();
            int nextSeparatorCount = (Integer)separatorsMap.get(nextSeparator);
            if (nextSeparatorCount <= maxCount) continue;
            maxCount = nextSeparatorCount;
            ret = nextSeparator;
        }
        return ret;
    }

    public static boolean isDoublePrecisionNumber(String text) {
        boolean ret = true;
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            ret = false;
        }
        return ret;
    }

    public static List<Long> networksStringToList(String networkIdStr) {
        ArrayList<Long> ret = new ArrayList<Long>();
        StringTokenizer st = new StringTokenizer(networkIdStr, SEMICOLON);
        while (st.hasMoreElements()) {
            String nextNetworkId = st.nextToken();
            try {
                ret.add(Long.parseLong(nextNetworkId));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Invalid network ID: " + nextNetworkId));
            }
        }
        return ret;
    }
}

