/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.genemania.domain.Gene;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;

public class GeneLinkoutGenerator {
    private static long At_ORG_ID = 1L;
    private static long Ce_ORG_ID = 2L;
    private static long Dm_ORG_ID = 3L;
    private static long Hs_ORG_ID = 4L;
    private static long Mm_ORG_ID = 5L;
    private static long SC_ORG_ID = 6L;
    private static String SOURCE_TAIR_ID = "TAIR ID";
    private static String SOURCE_ENTREZ_GENE_ID = "Entrez Gene ID";
    private static String SOURCE_ENTREZ_GENE_NAME = "Entrez Gene Name";
    private static String SOURCE_ENSEMBL_GENE_ID = "Ensembl Gene ID";
    private static String SOURCE_ENSEMBL_GENE_NAME = "Ensembl Gene Name";
    private static String SOURCE_GENE_NAME = "Gene Name";
    private static GeneLinkoutGenerator instance;
    Registry registry = new Registry();
    Generator entrez = new Generator(){
        static final String DISPLAY_NAME = "Entrez";
        static final String URL_TEMPLATE = "http://www.ncbi.nlm.nih.gov/sites/entrez?db=gene&cmd=search&term=%s";

        @Override
        Linkout check(Organism organism, Gene gene) {
            if (gene == null) {
                return null;
            }
            if (gene.getNamingSource() == null) {
                return null;
            }
            if (SOURCE_ENTREZ_GENE_ID.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String url = String.format(URL_TEMPLATE, gene.getSymbol());
                return new Linkout(DISPLAY_NAME, url);
            }
            return null;
        }
    };
    Generator tair = new Generator(){
        static final String DISPLAY_NAME = "TAIR";
        static final String URL_TEMPLATE = "http://arabidopsis.org/servlets/TairObject?type=locus&name=%s";

        @Override
        Linkout check(Organism organism, Gene gene) {
            if (gene == null) {
                return null;
            }
            if (gene.getNamingSource() == null) {
                return null;
            }
            if (SOURCE_TAIR_ID.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String url = String.format(URL_TEMPLATE, gene.getSymbol());
                return new Linkout(DISPLAY_NAME, url);
            }
            return null;
        }
    };
    Generator tairFromEntrez = new Generator(){
        static final String DISPLAY_NAME = "TAIR";
        static final String URL_TEMPLATE = "http://arabidopsis.org/servlets/TairObject?type=locus&name=%s";

        @Override
        Linkout check(Organism organism, Gene gene) {
            if (gene == null) {
                return null;
            }
            if (gene.getNamingSource() == null) {
                return null;
            }
            if (SOURCE_ENTREZ_GENE_NAME.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String symbol = gene.getSymbol();
                if (!symbol.startsWith("AT")) {
                    return null;
                }
                String url = String.format(URL_TEMPLATE, symbol);
                return new Linkout(DISPLAY_NAME, url);
            }
            if (SOURCE_GENE_NAME.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String symbol = gene.getSymbol();
                if (!symbol.startsWith("AT")) {
                    return null;
                }
                String url = String.format(URL_TEMPLATE, symbol);
                return new Linkout(DISPLAY_NAME, url);
            }
            return null;
        }
    };
    Generator tairOrTairFromEntrez = new Generator(){

        @Override
        Linkout generate(Organism organism, Node node) {
            Linkout linkout = GeneLinkoutGenerator.this.tair.generate(organism, node);
            if (linkout == null) {
                linkout = GeneLinkoutGenerator.this.tairFromEntrez.generate(organism, node);
            }
            return linkout;
        }
    };
    Generator ensembl = new Generator(){
        static final String DISPLAY_NAME = "Ensembl";
        static final String URL_TEMPLATE = "http://www.ensembl.org/%s/geneview?gene=%s";

        @Override
        Linkout check(Organism organism, Gene gene) {
            if (gene == null) {
                return null;
            }
            if (gene.getNamingSource() == null) {
                return null;
            }
            if (SOURCE_ENSEMBL_GENE_ID.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String organismName = organism.getAlias();
                organismName = organismName.replace(" ", "_");
                String url = String.format(URL_TEMPLATE, organismName, gene.getSymbol());
                return new Linkout(DISPLAY_NAME, url);
            }
            return null;
        }
    };
    Generator sgd = new Generator(){
        static final String DISPLAY_NAME = "SGD";
        static final String URL_TEMPLATE = "http://www.yeastgenome.org/cgi-bin/locus.fpl?locus=%s";

        @Override
        Linkout check(Organism organism, Gene gene) {
            if (gene == null) {
                return null;
            }
            if (gene.getNamingSource() == null) {
                return null;
            }
            if (SOURCE_ENSEMBL_GENE_NAME.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String url = String.format(URL_TEMPLATE, gene.getSymbol());
                return new Linkout(DISPLAY_NAME, url);
            }
            if (SOURCE_GENE_NAME.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String url = String.format(URL_TEMPLATE, gene.getSymbol());
                return new Linkout(DISPLAY_NAME, url);
            }
            return null;
        }
    };
    Generator bar = new Generator(){
        static final String DISPLAY_NAME = "BAR";
        static final String URL_TEMPLATE = "http://bar.utoronto.ca/efp/cgi-bin/efpWeb.cgi?modeInput=Absolute&ncbi_gi=%s";

        @Override
        Linkout check(Organism organism, Gene gene) {
            if (gene == null) {
                return null;
            }
            if (gene.getNamingSource() == null) {
                return null;
            }
            if (SOURCE_TAIR_ID.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String url = String.format(URL_TEMPLATE, gene.getSymbol());
                return new Linkout(DISPLAY_NAME, url);
            }
            return null;
        }
    };
    Generator flybase = new Generator(){
        static final String DISPLAY_NAME = "FlyBase";
        static final String URL_TEMPLATE = "http://flybase.org/reports/%s.html";

        @Override
        Linkout check(Organism organism, Gene gene) {
            if (gene == null) {
                return null;
            }
            if (gene.getNamingSource() == null) {
                return null;
            }
            if (SOURCE_ENSEMBL_GENE_ID.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String url = String.format(URL_TEMPLATE, gene.getSymbol());
                return new Linkout(DISPLAY_NAME, url);
            }
            return null;
        }
    };
    Generator wormbase = new Generator(){
        static final String DISPLAY_NAME = "WormBase";
        static final String URL_TEMPLATE = "http://www.wormbase.org/db/gene/gene?class=Gene&name=%s";

        @Override
        Linkout check(Organism organism, Gene gene) {
            if (gene == null) {
                return null;
            }
            if (gene.getNamingSource() == null) {
                return null;
            }
            if (SOURCE_ENSEMBL_GENE_ID.equalsIgnoreCase(gene.getNamingSource().getName())) {
                String url = String.format(URL_TEMPLATE, gene.getSymbol());
                return new Linkout(DISPLAY_NAME, url);
            }
            return null;
        }
    };
    Generator entrezOrEnsembl = new Generator(){

        @Override
        Linkout generate(Organism organism, Node node) {
            Linkout linkout = GeneLinkoutGenerator.this.entrez.generate(organism, node);
            if (linkout == null) {
                linkout = GeneLinkoutGenerator.this.ensembl.generate(organism, node);
            }
            return linkout;
        }
    };

    public static GeneLinkoutGenerator instance() {
        if (instance == null) {
            instance = new GeneLinkoutGenerator();
            instance.registerDefault();
        }
        return instance;
    }

    void registerDefault() {
        this.registry.register(At_ORG_ID, this.bar);
        this.registry.register(At_ORG_ID, this.tairOrTairFromEntrez);
        this.registry.register(At_ORG_ID, this.entrezOrEnsembl);
        this.registry.register(Ce_ORG_ID, this.wormbase);
        this.registry.register(Ce_ORG_ID, this.entrezOrEnsembl);
        this.registry.register(Dm_ORG_ID, this.flybase);
        this.registry.register(Dm_ORG_ID, this.entrezOrEnsembl);
        this.registry.register(Hs_ORG_ID, this.entrezOrEnsembl);
        this.registry.register(Mm_ORG_ID, this.entrezOrEnsembl);
        this.registry.register(SC_ORG_ID, this.sgd);
        this.registry.register(SC_ORG_ID, this.entrezOrEnsembl);
        this.registry.registerFallback(this.entrezOrEnsembl);
    }

    public Map<String, String> getLinkouts(Organism organism, Node node) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Iterator<Generator> generators = this.registry.iterator(organism.getId());
        while (generators.hasNext()) {
            Generator generator = generators.next();
            Linkout linkout = generator.generate(organism, node);
            if (linkout == null) continue;
            result.put(linkout.getName(), linkout.getUrl());
        }
        return result;
    }

    static class Linkout {
        String name;
        String url;

        public Linkout(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    class Generator {
        Generator() {
        }

        Linkout generate(Organism organism, Node node) {
            if (node == null || node.getGenes() == null) {
                return null;
            }
            for (Gene gene : node.getGenes()) {
                Linkout linkout = this.check(organism, gene);
                if (linkout == null) continue;
                return linkout;
            }
            return null;
        }

        Linkout check(Organism organism, Gene gene) {
            throw new RuntimeException("not implemented");
        }
    }

    class Registry {
        Map<Long, List<Generator>> registeredGenerators = new HashMap<Long, List<Generator>>();
        List<Generator> fallbackGenerators = new ArrayList<Generator>();

        Registry() {
        }

        void register(long organismId, Generator generator) {
            if (this.registeredGenerators.containsKey(organismId)) {
                List<Generator> generatorList = this.registeredGenerators.get(organismId);
                generatorList.add(generator);
            } else {
                ArrayList<Generator> generatorList = new ArrayList<Generator>();
                generatorList.add(generator);
                this.registeredGenerators.put(organismId, generatorList);
            }
        }

        void registerFallback(Generator generator) {
            this.fallbackGenerators.add(generator);
        }

        Iterator<Generator> iterator(long organismId) {
            if (this.registeredGenerators.containsKey(organismId)) {
                return this.registeredGenerators.get(organismId).iterator();
            }
            return this.fallbackGenerators.iterator();
        }
    }
}

