/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.LazyLoader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.Searcher;
import org.genemania.domain.Gene;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.Organism;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.NodeCursor;
import org.genemania.mediator.OrganismMediator;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.LuceneMediator;
import org.genemania.mediator.lucene.LuceneNodeCursor;
import org.genemania.mediator.lucene.ObjectProvider;

public class LuceneOrganismMediator
extends LuceneMediator
implements OrganismMediator {
    public LuceneOrganismMediator(Searcher searcher, Analyzer analyzer) {
        super(searcher, analyzer);
    }

    @Override
    public NodeCursor createNodeCursor(long organismId) {
        final ArrayList<ObjectProvider<Document>> result = new ArrayList<ObjectProvider<Document>>();
        this.search(String.format("%s:%d", "node_organism_id", organismId), new AbstractCollector(){

            @Override
            public void handleHit(final int doc) {
                result.add((ObjectProvider)Enhancer.create(ObjectProvider.class, (Callback)new LazyLoader(){

                    public Object loadObject() throws Exception {
                        return new ObjectProvider<Document>(LuceneOrganismMediator.this.searcher.doc(doc));
                    }
                }));
            }
        });
        return new LuceneNodeCursor(result);
    }

    @Override
    public List<Organism> getAllOrganisms() {
        return this.createOrganisms();
    }

    private List<Organism> createOrganisms() {
        final ArrayList<Organism> result = new ArrayList<Organism>();
        this.search(String.format("%s:%s", "type", "organism"), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneOrganismMediator.this.searcher.doc(doc);
                    result.add(LuceneOrganismMediator.this.createOrganism(document));
                }
                catch (CorruptIndexException e) {
                    LuceneOrganismMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneOrganismMediator.this.log(e);
                }
            }
        });
        return result;
    }

    @Override
    public List<Gene> getDefaultGenes(long organismId) {
        final Organism organism = this.createOrganism(organismId);
        final ArrayList<Gene> result = new ArrayList<Gene>();
        this.search(String.format("+%s:%s +%s:%s", "gene_organism_id", String.valueOf(organismId), "gene_selected", String.valueOf(true)), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneOrganismMediator.this.searcher.doc(doc);
                    result.add(LuceneOrganismMediator.this.createGene(document, null, organism, null));
                }
                catch (CorruptIndexException e) {
                    LuceneOrganismMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneOrganismMediator.this.log(e);
                }
            }
        });
        return result;
    }

    @Override
    public Organism getOrganism(long organismId) {
        return this.createOrganism(organismId);
    }

    @Override
    public List<?> hqlSearch(String queryString) {
        return null;
    }

    @Override
    public List<InteractionNetwork> getDefaultNetworks(long organismId) throws DataStoreException {
        final HashSet groupIds = new HashSet();
        this.search(String.format("%s:%s", "group_organism_id", String.valueOf(organismId)), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneOrganismMediator.this.searcher.doc(doc);
                    groupIds.add(Long.parseLong(document.get("group_id")));
                }
                catch (CorruptIndexException e) {
                    LuceneOrganismMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneOrganismMediator.this.log(e);
                }
            }
        });
        final ArrayList<InteractionNetwork> result = new ArrayList<InteractionNetwork>();
        this.search(String.format("%s:%s", "network_selected", String.valueOf(true)), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneOrganismMediator.this.searcher.doc(doc);
                    long groupId = Long.parseLong(document.get("network_group_id"));
                    if (groupIds.contains(groupId)) {
                        result.add(LuceneOrganismMediator.this.createNetwork(document));
                    }
                }
                catch (CorruptIndexException e) {
                    LuceneOrganismMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneOrganismMediator.this.log(e);
                }
            }
        });
        return result;
    }

    @Override
    public Organism getOrganismForGroup(long groupId) throws DataStoreException {
        final Organism[] result = new Organism[1];
        this.search(String.format("+%s:\"%d\"", "group_id", groupId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneOrganismMediator.this.searcher.doc(doc);
                    long organismId = Long.parseLong(document.get("group_organism_id"));
                    result[0] = LuceneOrganismMediator.this.createOrganism(organismId);
                }
                catch (CorruptIndexException e) {
                    LuceneOrganismMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneOrganismMediator.this.log(e);
                }
            }
        });
        return result[1];
    }
}

