/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneData;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.Organism;
import org.genemania.mediator.GeneMediator;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.LuceneMediator;

public class LuceneGeneMediator
extends LuceneMediator
implements GeneMediator {
    public LuceneGeneMediator(Searcher searcher, Analyzer analyzer) {
        super(searcher, analyzer);
    }

    @Override
    public GeneNamingSource findNamingSourceByName(String namingSourceName) {
        return this.createNamingSource(namingSourceName);
    }

    @Override
    public List<Gene> getAllGenes(long organismId) {
        return this.createGenes(organismId);
    }

    @Override
    public Gene getGeneForSymbol(Organism organism, String geneSymbol) {
        if (organism == null) {
            return this.createGene(geneSymbol);
        }
        return this.createGene(organism.getId(), geneSymbol);
    }

    @Override
    public List<Gene> getGenes(List<String> geneSymbols, long organismId) {
        return this.createGenes(organismId, geneSymbols);
    }

    @Override
    public void updateGeneData(Organism organism, String geneSymbol, GeneData geneData) {
    }

    @Override
    public boolean isValid(long organismId, String proposal) {
        return this.getCanonicalSymbol(organismId, proposal) != null;
    }

    @Override
    public String getCanonicalSymbol(long organismId, String proposal) {
        try {
            if (proposal.length() == 0) {
                return null;
            }
            TopDocs topDocs = this.search(String.format("+%s:\"%d\" +%s:\"%s\"", "gene_organism_id", organismId, "gene", QueryParser.escape((String)proposal)), 1);
            if (topDocs != null && topDocs.totalHits > 0) {
                Document document = this.searcher.doc(topDocs.scoreDocs[0].doc);
                return document.get("gene");
            }
            return null;
        }
        catch (IOException e) {
            this.log(e);
        }
        catch (BooleanQuery.TooManyClauses e) {
            this.log(e);
        }
        return null;
    }

    @Override
    public Set<String> getSynonyms(long organismId, String symbol) {
        Long nodeId = this.getNodeId(organismId, symbol);
        if (nodeId == null) {
            return Collections.emptySet();
        }
        return this.getSynonyms(organismId, nodeId);
    }

    @Override
    public Set<String> getSynonyms(long organismId, long nodeId) {
        String query = String.format("+%s:\"%d\" +%s:\"%d\"", "gene_organism_id", organismId, "node", nodeId);
        final HashSet<String> synonyms = new HashSet<String>();
        this.search(query, new AbstractCollector(){

            @Override
            public void handleHit(int id) {
                try {
                    Document document = LuceneGeneMediator.this.searcher.doc(id);
                    synonyms.add(document.get("gene"));
                }
                catch (IOException e) {
                    LuceneGeneMediator.this.log(e);
                }
            }
        });
        return synonyms;
    }

    @Override
    public Long getNodeId(long organismId, String symbol) {
        try {
            String query = String.format("+%s:\"%d\" +%s:\"%s\"", "gene_organism_id", organismId, "gene", QueryParser.escape((String)symbol));
            TopDocs topDocs = this.search(query, 1);
            if (topDocs != null && topDocs.totalHits >= 1) {
                Document document = this.searcher.doc(topDocs.scoreDocs[0].doc);
                return Long.parseLong(document.get("node"));
            }
        }
        catch (IOException e) {
            this.log(e);
        }
        return null;
    }
}

