/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.impl;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.InteractionCursor;

public class FileInteractionCursor
implements InteractionCursor {
    private long networkId;
    private File file;
    String fileEncoding;
    protected int idCol1;
    protected int idCol2;
    protected int weightCol;
    char delim;
    CSVReader reader;
    protected String[] nextLine;

    public FileInteractionCursor(long networkId, File file, String fileEncoding, int idCol1, int idCol2, int weightCol, char delim) throws ApplicationException {
        this.networkId = networkId;
        this.file = file;
        this.idCol1 = idCol1;
        this.idCol2 = idCol2;
        this.weightCol = weightCol;
        this.fileEncoding = fileEncoding;
        this.delim = delim;
        this.reader = this.open();
    }

    public FileInteractionCursor(long networkId, File file) throws ApplicationException {
        this(networkId, file, "UTF8", 0, 1, 2, '\t');
    }

    private CSVReader open() throws ApplicationException {
        try {
            InputStream stream = this.getStream(this.file);
            BufferedReader source = new BufferedReader(new InputStreamReader(stream, this.fileEncoding));
            CSVReader csvReader = new CSVReader((Reader)source, this.delim);
            return csvReader;
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
    }

    private InputStream getStream(File file) throws FileNotFoundException {
        try {
            return new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            return new FileInputStream(file);
        }
    }

    @Override
    public long getId() throws ApplicationException {
        throw new ApplicationException("'Id' not supported for interaction files");
    }

    @Override
    public long getFromNodeId() throws ApplicationException {
        return Long.parseLong(this.nextLine[this.idCol1]);
    }

    @Override
    public long getToNodeId() throws ApplicationException {
        return Long.parseLong(this.nextLine[this.idCol2]);
    }

    @Override
    public float getWeight() throws ApplicationException {
        if (this.weightCol < 0) {
            return 1.0f;
        }
        return Float.parseFloat(this.nextLine[this.weightCol]);
    }

    @Override
    public long getTotalInteractions() throws ApplicationException {
        long lineCount = 0L;
        CSVReader countReader = null;
        try {
            countReader = this.open();
            while (countReader.readNext() != null) {
                ++lineCount;
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        finally {
            try {
                countReader.close();
            }
            catch (Exception e) {}
        }
        return lineCount;
    }

    @Override
    public void close() throws ApplicationException {
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
        }
    }

    @Override
    public boolean next() throws ApplicationException {
        try {
            this.nextLine = this.reader.readNext();
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        return this.nextLine != null;
    }

    @Override
    public long getNetworkId() {
        return this.networkId;
    }
}

