/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.profile;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.genemania.data.profile.ReaderProfileCursor;

public class SoftProfileCursor
extends ReaderProfileCursor {
    private static final Pattern METADATA = Pattern.compile("^[!^#].*");
    private static final Pattern GDS_HEADER = Pattern.compile("GDS\\d+");
    private static final Pattern GSM_HEADER = Pattern.compile("GSM\\d+");
    String[] current;
    String next;
    int idColumn;
    List<Integer> dataColumns = new ArrayList<Integer>();
    List<String> headers = new ArrayList<String>();

    public SoftProfileCursor(Reader reader) throws IOException {
        super(reader);
        this.findDataLine();
        if (this.next != null) {
            if (GDS_HEADER.matcher(this.next).matches()) {
                this.handleAnnotatedFormat();
            } else {
                this.handleSoftFormat();
            }
        }
    }

    private boolean isIdColumn(String data) {
        return "gene symbol".equalsIgnoreCase(data) || "identifier".equalsIgnoreCase(data);
    }

    private void handleSoftFormat() {
        int i;
        this.headers.add("ID");
        this.idColumn = 0;
        String[] header = this.next.split("\t");
        for (i = 0; i < header.length; ++i) {
            if (this.isIdColumn(header[i])) {
                this.idColumn = i;
                continue;
            }
            if (!GSM_HEADER.matcher(header[i]).matches()) continue;
            this.dataColumns.add(i);
            this.headers.add(header[i]);
        }
        if (this.headers.size() == 1) {
            for (i = 0; i < header.length; ++i) {
                if (i == this.idColumn) continue;
                this.dataColumns.add(i);
                this.headers.add(header[i]);
            }
        }
        this.findDataLine();
    }

    private void handleAnnotatedFormat() throws IOException {
        this.headers.add("ID");
        String header = this.reader.readLine();
        if (header == null) {
            return;
        }
        String[] parts = header.split("\t");
        for (int i = 0; i < parts.length; ++i) {
            if (this.isIdColumn(parts[i])) {
                this.idColumn = i;
                continue;
            }
            if (!GSM_HEADER.matcher(parts[i]).matches()) continue;
            this.dataColumns.add(i);
            this.headers.add(parts[i]);
        }
        this.reader.readLine();
        this.next = this.reader.readLine();
    }

    @Override
    public String getId() {
        return this.current[this.idColumn];
    }

    @Override
    public int getTotalValues() {
        return this.dataColumns.size();
    }

    @Override
    public double getValue(int index) {
        try {
            return Double.parseDouble(this.current[this.dataColumns.get(index)]);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @Override
    public boolean next() {
        if (this.next == null) {
            return false;
        }
        if (this.next.trim().length() == 0) {
            this.next = null;
            return false;
        }
        this.current = this.next.split("\t");
        this.findDataLine();
        return true;
    }

    void findDataLine() {
        try {
            while ((this.next = this.reader.readLine()) != null && METADATA.matcher(this.next).matches()) {
            }
        }
        catch (IOException e) {
            this.next = null;
        }
    }

    @Override
    public String getHeader(int index) {
        return this.headers.get(index);
    }

    @Override
    public int getTotalHeaders() {
        return this.headers.size();
    }
}

