/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.normalizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.genemania.data.classification.IGeneClassificationHandler;
import org.genemania.data.classification.IGeneClassifier;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;

public class OrganismClassifier {
    private static final double DEFAULT_TOLERANCE = 0.25;
    private IGeneClassifier classifier;
    private Map<Long, Integer> votes;
    private Set<String> seenSymbols;
    private String delimiter;
    private Map<Long, Set<Integer>> idColumnsByOrganism;

    public OrganismClassifier(IGeneClassifier classifier) {
        this.classifier = classifier;
        this.votes = new HashMap<Long, Integer>();
        this.seenSymbols = new HashSet<String>();
        this.delimiter = "\t";
        this.idColumnsByOrganism = new HashMap<Long, Set<Integer>>();
    }

    public void classify(DataImportSettings result, Reader source, int maximumLinesToSample) throws IOException, ApplicationException {
        String line;
        BufferedReader reader = new BufferedReader(source);
        for (int i = 0; i < maximumLinesToSample && (line = reader.readLine()) != null; ++i) {
            String[] parts = line.split(this.delimiter);
            for (int column = 0; column < parts.length; ++column) {
                this.addGene(parts[column], column);
            }
        }
        if (this.votes.size() == 0) {
            result.setOrganism(null);
        } else {
            Organism organism = new Organism();
            long organismId = this.getMostLikelyOrganismIds().get((int)0).organismId;
            organism.setId(organismId);
            result.setOrganism(organism);
            result.setOrganismConfidence(this.getScore(organismId));
            ArrayList<Integer> idColumns = new ArrayList<Integer>((Collection)this.idColumnsByOrganism.get(organismId));
            Collections.sort(idColumns);
            result.setIdColumns(idColumns);
        }
    }

    public double getScore(long organismId) {
        if (!this.votes.containsKey(organismId)) {
            return 0.0;
        }
        return (double)this.votes.get(organismId).intValue() / (double)this.seenSymbols.size();
    }

    public List<Match> getMostLikelyOrganismIds() {
        return this.getMostLikelyOrganismIds(0.25);
    }

    public List<Match> getMostLikelyOrganismIds(double tolerance) {
        ArrayList<Match> ids = new ArrayList<Match>();
        int maxVotes = 0;
        for (Integer n : this.votes.values()) {
            maxVotes = Math.max(maxVotes, n);
        }
        for (Map.Entry entry : this.votes.entrySet()) {
            double percentDifference = (double)(maxVotes - (Integer)entry.getValue()) / (double)maxVotes;
            if (!(percentDifference <= tolerance)) continue;
            double score = (double)((Integer)entry.getValue()).intValue() / (double)maxVotes;
            ids.add(new Match((Long)entry.getKey(), score));
        }
        Collections.sort(ids, new Comparator<Match>(){

            @Override
            public int compare(Match o1, Match o2) {
                if (o2.score == o1.score) {
                    return 0;
                }
                return o2.score > o1.score ? 1 : -1;
            }
        });
        return ids;
    }

    public void addGene(String symbol, final int column) throws ApplicationException {
        if (this.seenSymbols.contains(symbol)) {
            return;
        }
        this.seenSymbols.add(symbol);
        this.classifier.classify(symbol, new IGeneClassificationHandler(){

            @Override
            public void handleClassification(String symbol, long organismId) {
                if (OrganismClassifier.this.votes.containsKey(organismId)) {
                    OrganismClassifier.this.votes.put(organismId, (Integer)OrganismClassifier.this.votes.get(organismId) + 1);
                } else {
                    OrganismClassifier.this.votes.put(organismId, 1);
                }
                HashSet<Integer> idColumns = (HashSet<Integer>)OrganismClassifier.this.idColumnsByOrganism.get(organismId);
                if (idColumns == null) {
                    idColumns = new HashSet<Integer>();
                    OrganismClassifier.this.idColumnsByOrganism.put(organismId, idColumns);
                }
                idColumns.add(column);
            }
        });
    }

    public boolean hasUniqueMatch() {
        int perfectMatches = 0;
        for (int hits : this.votes.values()) {
            if (hits != this.seenSymbols.size()) continue;
            ++perfectMatches;
        }
        return perfectMatches == 1;
    }

    public static class Match {
        public long organismId;
        public double score;

        public Match(long organismId, double score) {
            this.organismId = organismId;
            this.score = score;
        }
    }
}

