/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.connector;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.domain.Statistics;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.lucene.LuceneAttributeMediator;
import org.genemania.mediator.lucene.LuceneGeneMediator;
import org.genemania.mediator.lucene.LuceneMediator;
import org.genemania.mediator.lucene.LuceneNetworkMediator;
import org.genemania.mediator.lucene.LuceneNodeMediator;
import org.genemania.mediator.lucene.LuceneOrganismMediator;
import org.genemania.mediator.lucene.LuceneStatsMediator;
import org.genemania.util.ApplicationConfig;

public class LuceneConnector {
    private static LuceneConnector instance = new LuceneConnector();
    private static Logger LOG = Logger.getLogger(LuceneConnector.class);
    private LuceneOrganismMediator organismMediator = null;
    private LuceneGeneMediator geneMediator = null;
    private LuceneNetworkMediator networkMediator = null;
    private LuceneNodeMediator nodeMediator = null;
    private LuceneStatsMediator statsMediator = null;
    private LuceneAttributeMediator attributeMediator = null;
    private Searcher searcher;
    private Analyzer analyzer;

    private LuceneConnector() {
        try {
            String indexPath = ApplicationConfig.getInstance().getProperty("geneindexdir");
            this.searcher = LuceneConnector.createSearcher(indexPath);
            this.analyzer = LuceneMediator.createDefaultAnalyzer();
            this.organismMediator = new LuceneOrganismMediator(this.searcher, this.analyzer);
            this.geneMediator = new LuceneGeneMediator(this.searcher, this.analyzer);
            this.networkMediator = new LuceneNetworkMediator(this.searcher, this.analyzer);
            this.nodeMediator = new LuceneNodeMediator(this.searcher, this.analyzer);
            this.statsMediator = new LuceneStatsMediator(this.searcher, this.analyzer);
            this.attributeMediator = new LuceneAttributeMediator(this.searcher, this.analyzer);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    public static LuceneConnector getInstance() {
        return instance;
    }

    public List<InteractionNetworkGroup> findNetworkGroupsByOrganism(long organismId) throws DataStoreException {
        return this.networkMediator.getNetworkGroupsByOrganism(organismId);
    }

    public List<Organism> retrieveAllOrganisms() throws DataStoreException {
        return this.organismMediator.getAllOrganisms();
    }

    public Organism findOrganismById(long organismId) throws DataStoreException {
        return this.organismMediator.getOrganism(organismId);
    }

    public List<Gene> retrieveDefaultGenesFor(long organismId) throws DataStoreException {
        return this.organismMediator.getDefaultGenes(organismId);
    }

    public List<InteractionNetwork> retrieveDefaultNetworksFor(long organismId) throws DataStoreException {
        return this.organismMediator.getDefaultNetworks(organismId);
    }

    public List<Gene> findGenesBySymbol(long organismId, List<String> geneSymbols) throws DataStoreException {
        return this.geneMediator.getGenes(geneSymbols, organismId);
    }

    public InteractionNetwork findNetworkById(long networkId) throws DataStoreException {
        return this.networkMediator.getNetwork(networkId);
    }

    public Node findNodeById(long nodeId, long organismId) {
        return this.nodeMediator.getNode(nodeId, organismId);
    }

    public Statistics getLatestStatistics() {
        return this.statsMediator.getLatestStatistics();
    }

    public boolean isValid(long organismId, String geneSymbol) {
        return this.geneMediator.isValid(organismId, geneSymbol);
    }

    public Long getNodeId(long organismId, String symbol) {
        return this.geneMediator.getNodeId(organismId, symbol);
    }

    public InteractionNetworkGroup getNetworkGroupByName(long organismId, String groupName) {
        return this.networkMediator.getNetworkGroupByName(groupName, organismId);
    }

    public Organism getOrganismForGroup(long id) throws DataStoreException {
        return this.organismMediator.getOrganismForGroup(id);
    }

    public InteractionNetworkGroup getGroupForNetwork(long networkId) {
        return this.networkMediator.getNetworkGroupForNetwork(networkId);
    }

    public boolean isValidNetwork(long organismId, long networkId) {
        return this.networkMediator.isValidNetwork(organismId, networkId);
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    private static Searcher createSearcher(String indexPath) throws IOException {
        ArrayList<IndexSearcher> searchers = new ArrayList<IndexSearcher>();
        File indices = new File(indexPath);
        File[] fileList = indices.listFiles();
        if (fileList == null) {
            throw new IOException(String.format("Unable to load indices from path '%s', not a directory or I/O error", indexPath));
        }
        for (File file : fileList) {
            try {
                if (!LuceneMediator.indexExists(file)) continue;
                FSDirectory directory = FSDirectory.open((File)file);
                searchers.add(new IndexSearcher((Directory)directory));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (searchers.size() == 0) {
            throw new IOException("No indices found");
        }
        return new MultiSearcher(searchers.toArray(new Searchable[searchers.size()]));
    }

    public Attribute findAttribute(long organismId, long attributeId) {
        return this.attributeMediator.findAttribute(organismId, attributeId);
    }

    public boolean isValidAttribute(long organismId, long attributeId) {
        return this.attributeMediator.isValidAttribute(organismId, attributeId);
    }

    public List<Attribute> findAttributesByGroup(long organismId, long attributeGroupId) {
        return this.attributeMediator.findAttributesByGroup(organismId, attributeGroupId);
    }

    public List<AttributeGroup> findAttributeGroupsByOrganism(long organismId) {
        return this.attributeMediator.findAttributeGroupsByOrganism(organismId);
    }

    public AttributeGroup findAttributeGroup(long organismId, long attributeGroupId) {
        return this.attributeMediator.findAttributeGroup(organismId, attributeGroupId);
    }
}

