/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util;

import com.jidesoft.thirdparty.prefuse.util.collections.IntObjectHashMap;
import java.awt.Font;

public class FontLib {
    private static final IntObjectHashMap fontMap = new IntObjectHashMap();
    private static int misses = 0;
    private static int lookups = 0;

    public static Font getFont(String string, double d2) {
        int n2 = (int)Math.floor(d2);
        return FontLib.getFont(string, 0, n2);
    }

    public static Font getFont(String string, int n2, double d2) {
        int n3 = (int)Math.floor(d2);
        return FontLib.getFont(string, n2, n3);
    }

    public static Font getFont(String string, int n2, int n3) {
        int n4 = (string.hashCode() << 8) + (n3 << 2) + n2;
        Font font = null;
        font = (Font)fontMap.get(n4);
        if (font == null) {
            font = new Font(string, n2, n3);
            fontMap.put(n4, font);
            ++misses;
        }
        ++lookups;
        return font;
    }

    public static int getCacheMissCount() {
        return misses;
    }

    public static int getCacheLookupCount() {
        return lookups;
    }

    public static void clearCache() {
        fontMap.clear();
    }

    public static Font getIntermediateFont(Font font, Font font2, double d2) {
        int n2;
        String string;
        if (d2 < 0.5) {
            string = font.getName();
            n2 = font.getStyle();
        } else {
            string = font2.getName();
            n2 = font2.getStyle();
        }
        int n3 = (int)Math.round(d2 * (double)font2.getSize() + (1.0 - d2) * (double)font.getSize());
        return FontLib.getFont(string, n2, n3);
    }
}

