/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.tuple;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.tuple.TableTuple;
import com.jidesoft.thirdparty.prefuse.util.StringLib;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import java.util.Iterator;
import java.util.logging.Logger;

public class TupleManager {
    protected Table m_table;
    protected Class m_tupleType;
    private TableTuple[] m_tuples;

    public TupleManager(Table table, Class clazz) {
        this.init(table, clazz);
    }

    public void init(Table table, Class clazz) {
        if (this.m_table != null) {
            throw new IllegalStateException("This TupleManager has already been initialized");
        }
        this.m_table = table;
        this.m_tupleType = clazz;
        this.m_tuples = null;
    }

    public Class getTupleType() {
        return this.m_tupleType;
    }

    private void ensureTupleArray() {
        int n2 = this.m_table.getRowCount();
        if (this.m_tuples == null) {
            this.m_tuples = new TableTuple[n2];
        } else if (this.m_tuples.length < n2) {
            int n3 = Math.max(3 * this.m_tuples.length / 2 + 1, n2);
            TableTuple[] tableTupleArray = new TableTuple[n3];
            System.arraycopy(this.m_tuples, 0, tableTupleArray, 0, this.m_tuples.length);
            this.m_tuples = tableTupleArray;
        }
    }

    public Tuple getTuple(int n2) {
        if (this.m_table.isValidRow(n2)) {
            this.ensureTupleArray();
            if (this.m_tuples[n2] == null) {
                this.m_tuples[n2] = this.newTuple(n2);
                return this.m_tuples[n2];
            }
            return this.m_tuples[n2];
        }
        throw new IllegalArgumentException("Invalid row index: " + n2);
    }

    protected TableTuple newTuple(int n2) {
        try {
            TableTuple tableTuple = (TableTuple)this.m_tupleType.newInstance();
            tableTuple.init(this.m_table, n2);
            return tableTuple;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).warning(exception.getMessage() + "\n" + StringLib.getStackTrace(exception));
            return null;
        }
    }

    public void invalidate(int n2) {
        if (this.m_tuples == null || n2 < 0 || n2 > this.m_tuples.length) {
            return;
        }
        if (this.m_tuples[n2] != null) {
            this.m_tuples[n2].invalidate();
            this.m_tuples[n2] = null;
        }
    }

    public void invalidateAll() {
        if (this.m_tuples == null) {
            return;
        }
        for (int i2 = 0; i2 < this.m_tuples.length; ++i2) {
            this.invalidate(i2);
        }
    }

    public Iterator iterator(IntIterator intIterator) {
        return new TupleManagerIterator(this, intIterator);
    }

    public class TupleManagerIterator
    implements Iterator {
        private TupleManager m_tuples;
        private IntIterator m_rows;

        public TupleManagerIterator(TupleManager tupleManager2, IntIterator intIterator) {
            this.m_tuples = tupleManager2;
            this.m_rows = intIterator;
        }

        public boolean hasNext() {
            return this.m_rows.hasNext();
        }

        public Object next() {
            return this.m_tuples.getTuple(this.m_rows.nextInt());
        }

        public void remove() {
            this.m_rows.remove();
        }
    }
}

