/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.expression.AbsFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.AcosFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.AsinFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.Atan2Function;
import com.jidesoft.thirdparty.prefuse.data.expression.AtanFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.CapFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.CeilFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.ConcatFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.ConcatWsFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.CosFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.CotFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.DegreesFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.EFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.FloorFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.FormatFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.Function;
import com.jidesoft.thirdparty.prefuse.data.expression.LPadFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.LeftFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.LengthFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.Log10Function;
import com.jidesoft.thirdparty.prefuse.data.expression.Log2Function;
import com.jidesoft.thirdparty.prefuse.data.expression.LogFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.LowerFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.MaxFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.PiFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.PositionFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.PowFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.RPadFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.RadiansFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.RandFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.RepeatFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.ReplaceFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.ReverseFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.RightFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.RoundFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.RowFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.SafeLog10Function;
import com.jidesoft.thirdparty.prefuse.data.expression.SafeSqrtFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.SignFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.SinFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.SpaceFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.SqrtFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.SubstringFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.SumFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.TanFunction;
import com.jidesoft.thirdparty.prefuse.data.expression.UpperFunction;
import java.util.HashMap;

public class FunctionTable {
    private static HashMap s_functionTable = new HashMap();

    private FunctionTable() {
    }

    public static boolean hasFunction(String string) {
        return s_functionTable.containsKey(string);
    }

    public static void addFunction(String string, Class clazz) {
        if (!Function.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Type argument must be a subclass of FunctionExpression.");
        }
        if (FunctionTable.hasFunction(string)) {
            throw new IllegalArgumentException("Function with that name already exists");
        }
        String string2 = string.toLowerCase();
        String string3 = string.toUpperCase();
        if (!string.equals(string2) && !string.equals(string3)) {
            throw new IllegalArgumentException("Name can't have mixed case, try \"" + string3 + "\" instead.");
        }
        s_functionTable.put(string2, clazz);
        s_functionTable.put(string3, clazz);
    }

    public static Function createFunction(String string) {
        Class clazz = (Class)s_functionTable.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException("Unrecognized function name");
        }
        try {
            return (Function)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    static {
        FunctionTable.addFunction("ROW", RowFunction.class);
        FunctionTable.addFunction("ABS", AbsFunction.class);
        FunctionTable.addFunction("ACOS", AcosFunction.class);
        FunctionTable.addFunction("ASIN", AsinFunction.class);
        FunctionTable.addFunction("ATAN", AtanFunction.class);
        FunctionTable.addFunction("ATAN2", Atan2Function.class);
        FunctionTable.addFunction("CEIL", CeilFunction.class);
        FunctionTable.addFunction("CEILING", CeilFunction.class);
        FunctionTable.addFunction("COS", CosFunction.class);
        FunctionTable.addFunction("COT", CotFunction.class);
        FunctionTable.addFunction("DEGREES", DegreesFunction.class);
        FunctionTable.addFunction("E", EFunction.class);
        FunctionTable.addFunction("EXP", ExpFunction.class);
        FunctionTable.addFunction("FLOOR", FloorFunction.class);
        FunctionTable.addFunction("LOG", LogFunction.class);
        FunctionTable.addFunction("LOG2", Log2Function.class);
        FunctionTable.addFunction("LOG10", Log10Function.class);
        FunctionTable.addFunction("MAX", MaxFunction.class);
        FunctionTable.addFunction("MIN", MaxFunction.class);
        FunctionTable.addFunction("MOD", MaxFunction.class);
        FunctionTable.addFunction("PI", PiFunction.class);
        FunctionTable.addFunction("POW", PowFunction.class);
        FunctionTable.addFunction("POWER", PowFunction.class);
        FunctionTable.addFunction("RADIANS", RadiansFunction.class);
        FunctionTable.addFunction("RAND", RandFunction.class);
        FunctionTable.addFunction("ROUND", RoundFunction.class);
        FunctionTable.addFunction("SIGN", SignFunction.class);
        FunctionTable.addFunction("SIN", SinFunction.class);
        FunctionTable.addFunction("SQRT", SqrtFunction.class);
        FunctionTable.addFunction("SUM", SumFunction.class);
        FunctionTable.addFunction("TAN", TanFunction.class);
        FunctionTable.addFunction("SAFELOG10", SafeLog10Function.class);
        FunctionTable.addFunction("SAFESQRT", SafeSqrtFunction.class);
        FunctionTable.addFunction("CAP", CapFunction.class);
        FunctionTable.addFunction("CONCAT", ConcatFunction.class);
        FunctionTable.addFunction("CONCAT_WS", ConcatWsFunction.class);
        FunctionTable.addFunction("FORMAT", FormatFunction.class);
        FunctionTable.addFunction("INSERT", RPadFunction.class);
        FunctionTable.addFunction("LENGTH", LengthFunction.class);
        FunctionTable.addFunction("LOWER", LowerFunction.class);
        FunctionTable.addFunction("LCASE", LowerFunction.class);
        FunctionTable.addFunction("LEFT", LeftFunction.class);
        FunctionTable.addFunction("LPAD", LPadFunction.class);
        FunctionTable.addFunction("MID", SubstringFunction.class);
        FunctionTable.addFunction("POSITION", PositionFunction.class);
        FunctionTable.addFunction("REVERSE", ReverseFunction.class);
        FunctionTable.addFunction("REPEAT", RepeatFunction.class);
        FunctionTable.addFunction("REPLACE", ReplaceFunction.class);
        FunctionTable.addFunction("RIGHT", RightFunction.class);
        FunctionTable.addFunction("RPAD", RPadFunction.class);
        FunctionTable.addFunction("SPACE", SpaceFunction.class);
        FunctionTable.addFunction("SUBSTRING", SubstringFunction.class);
        FunctionTable.addFunction("UPPER", UpperFunction.class);
        FunctionTable.addFunction("UCASE", UpperFunction.class);
    }
}

