/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data;

import com.jidesoft.thirdparty.prefuse.data.Table;
import java.util.HashMap;

public class Schema
implements Cloneable {
    private String[] m_names;
    private Class[] m_types;
    private Object[] m_dflts;
    private HashMap m_lookup;
    private int m_size;
    private boolean m_locked;

    public Schema() {
        this(10);
    }

    public Schema(int n2) {
        this.m_names = new String[n2];
        this.m_types = new Class[n2];
        this.m_dflts = new Object[n2];
        this.m_size = 0;
        this.m_locked = false;
    }

    public Schema(String[] stringArray, Class[] classArray) {
        this(stringArray.length);
        if (stringArray.length != classArray.length) {
            throw new IllegalArgumentException("Input arrays should be the same length");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.addColumn(stringArray[i2], classArray[i2], null);
        }
    }

    public Schema(String[] stringArray, Class[] classArray, Object[] objectArray) {
        this(stringArray.length);
        if (stringArray.length != classArray.length || classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Input arrays should be the same length");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.addColumn(stringArray[i2], classArray[i2], objectArray[i2]);
        }
    }

    public Object clone() {
        return new Schema(this.m_names, this.m_types, this.m_dflts);
    }

    protected void initLookup() {
        this.m_lookup = new HashMap();
        for (int i2 = 0; i2 < this.m_names.length; ++i2) {
            this.m_lookup.put(this.m_names[i2], new Integer(i2));
        }
    }

    public Schema lockSchema() {
        this.m_locked = true;
        return this;
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public void addColumn(String string, Class clazz) {
        this.addColumn(string, clazz, null);
    }

    public void addColumn(String string, Class clazz, Object object) {
        int n2;
        if (this.m_locked) {
            throw new IllegalStateException("Can not add column to a locked Schema.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null column names are not allowed.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Null column types are not allowed.");
        }
        for (n2 = 0; n2 < this.m_size; ++n2) {
            if (!this.m_names[n2].equals(string)) continue;
            throw new IllegalArgumentException("Duplicate column names are not allowed: " + this.m_names[n2]);
        }
        if (this.m_names.length == this.m_size) {
            n2 = 3 * this.m_names.length / 2 + 1;
            String[] stringArray = new String[n2];
            Class[] classArray = new Class[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.m_names, 0, stringArray, 0, this.m_size);
            System.arraycopy(this.m_types, 0, classArray, 0, this.m_size);
            System.arraycopy(this.m_dflts, 0, objectArray, 0, this.m_size);
            this.m_names = stringArray;
            this.m_types = classArray;
            this.m_dflts = objectArray;
        }
        this.m_names[this.m_size] = string;
        this.m_types[this.m_size] = clazz;
        this.m_dflts[this.m_size] = object;
        if (this.m_lookup != null) {
            this.m_lookup.put(string, new Integer(this.m_size));
        }
        ++this.m_size;
    }

    public int getColumnCount() {
        return this.m_size;
    }

    public String getColumnName(int n2) {
        return this.m_names[n2];
    }

    public int getColumnIndex(String string) {
        Integer n2;
        if (this.m_lookup == null) {
            this.initLookup();
        }
        return (n2 = (Integer)this.m_lookup.get(string)) == null ? -1 : n2;
    }

    public Class getColumnType(int n2) {
        return this.m_types[n2];
    }

    public Class getColumnType(String string) {
        int n2 = this.getColumnIndex(string);
        return n2 < 0 ? null : this.m_types[n2];
    }

    public Object getDefault(int n2) {
        return this.m_dflts[n2];
    }

    public Object getDefault(String string) {
        int n2 = this.getColumnIndex(string);
        return n2 < 0 ? null : this.m_dflts[n2];
    }

    public void setDefault(int n2, Object object) {
        if (this.m_locked) {
            throw new IllegalStateException("Can not update default values of a locked Schema.");
        }
        this.m_dflts[n2] = object;
    }

    public void setDefault(String string, Object object) {
        if (this.m_locked) {
            throw new IllegalStateException("Can not update default values of a locked Schema.");
        }
        int n2 = this.getColumnIndex(string);
        this.m_dflts[n2] = object;
    }

    public void setDefault(String string, int n2) {
        this.setDefault(string, (Object)new Integer(n2));
    }

    public void setDefault(String string, long l2) {
        this.setDefault(string, (Object)new Long(l2));
    }

    public void setDefault(String string, float f2) {
        this.setDefault(string, (Object)new Float(f2));
    }

    public void setDefault(String string, double d2) {
        this.setDefault(string, (Object)new Double(d2));
    }

    public void setDefault(String string, boolean bl) {
        this.setDefault(string, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)object;
        if (this.m_size != schema.getColumnCount()) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_size; ++i2) {
            if (this.m_names[i2].equals(schema.getColumnName(i2)) && this.m_types[i2].equals(schema.getColumnType(i2)) && this.m_dflts[i2].equals(schema.getDefault(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean isAssignableFrom(Schema schema) {
        int n2 = schema.getColumnCount();
        if (n2 > this.m_size) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getColumnIndex(schema.getColumnName(i2));
            if (n3 < 0) {
                return false;
            }
            if (this.m_types[n3].equals(schema.getColumnType(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.m_size; ++i2) {
            int n3 = i2 + 1;
            int n4 = n3 * this.m_names[i2].hashCode();
            n4 ^= n3 * this.m_types[i2].hashCode();
            if (this.m_dflts[i2] != null) {
                n4 ^= this.m_dflts[i2].hashCode();
            }
            n2 ^= n4;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Schema[");
        for (int i2 = 0; i2 < this.m_size; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('(').append(this.m_names[i2]).append(", ");
            stringBuffer.append(this.m_types[i2].getName()).append(", ");
            stringBuffer.append(this.m_dflts[i2]).append(')');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Table instantiate() {
        return this.instantiate(0);
    }

    public Table instantiate(int n2) {
        Table table = new Table(n2, this.m_size);
        for (int i2 = 0; i2 < this.m_size; ++i2) {
            table.addColumn(this.m_names[i2], this.m_types[i2], this.m_dflts[i2]);
        }
        return table;
    }
}

