/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.variants;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.feature.genome.Genome;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;
import savant.api.data.PointRecord;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;

public class MergedMedSavantVariantRecord
implements VariantRecord {
    private int count;
    private int start_position;
    private int end_position;
    private String chrom;
    private String name = "";
    private VariantType[][] variantTypes;
    private String ref;
    private VariantType defaultVariantType = VariantType.NONE;
    private List<String> altAlleles = new ArrayList<String>();
    private int[][] participantAlts;

    public MergedMedSavantVariantRecord(Object[] base, int participantCount) {
        this.chrom = (String)base[4];
        this.start_position = (Integer)base[5];
        this.end_position = (Integer)base[6];
        this.ref = (String)base[8];
        this.count = participantCount;
        this.variantTypes = new VariantType[this.count][];
        this.participantAlts = new int[this.count][];
    }

    public void addRecord(Object[] arr, int index) {
        if (this.name.length() == 0) {
            this.name = (String)arr[7];
        }
        String[] alts = ((String)arr[9]).split(",");
        for (int i = 0; i < alts.length; ++i) {
            if (this.altAlleles.contains(alts[i])) continue;
            this.altAlleles.add(alts[i]);
        }
        String[] gt = ((String)arr[15]).split("/|\\\\|\\|");
        int[] participantAlt = new int[gt.length];
        VariantType[] participantVariant = new VariantType[gt.length];
        boolean foundNonZero = false;
        for (int i = 0; i < gt.length; ++i) {
            try {
                Integer x = Integer.parseInt(gt[i]);
                if (x == 0) {
                    participantAlt[i] = 0;
                    participantVariant[i] = VariantType.NONE;
                    continue;
                }
                participantAlt[i] = this.altAlleles.indexOf(alts[x - 1]) + 1;
                participantVariant[i] = MergedMedSavantVariantRecord.convertVariantType(VariantRecord.VariantType.valueOf((String)arr[13]), alts[x - 1]);
                this.defaultVariantType = participantVariant[i];
                foundNonZero = true;
                continue;
            }
            catch (Exception e) {
                participantAlt[i] = 0;
                participantVariant[i] = VariantType.OTHER;
            }
        }
        if (foundNonZero) {
            this.participantAlts[index] = participantAlt;
            this.variantTypes[index] = participantVariant;
        }
    }

    public VariantType getVariantType() {
        return this.defaultVariantType;
    }

    public String getRefBases() {
        return this.ref;
    }

    public String[] getAltAlleles() {
        String[] alts = new String[this.altAlleles.size()];
        for (int i = 0; i < this.altAlleles.size(); ++i) {
            alts[i] = this.altAlleles.get(i);
        }
        return alts;
    }

    public int getParticipantCount() {
        return this.count;
    }

    public VariantType[] getVariantsForParticipant(int index) {
        if (this.variantTypes[index] == null) {
            return new VariantType[]{VariantType.NONE};
        }
        return this.variantTypes[index];
    }

    public int[] getAllelesForParticipant(int index) {
        if (this.participantAlts[index] == null) {
            return new int[]{0};
        }
        return this.participantAlts[index];
    }

    public int getPosition() {
        return this.start_position;
    }

    public int getStartPosition() {
        return this.start_position;
    }

    public int getEndPosition() {
        return this.end_position;
    }

    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.chrom;
    }

    public int compareTo(Object o) {
        if (!(o instanceof PointRecord)) {
            return -1;
        }
        PointRecord other = (PointRecord)o;
        int chromCompare = new Genome.ChromosomeComparator().compare(this.chrom, other.getReference());
        if (chromCompare != 0) {
            return chromCompare;
        }
        return Integer.valueOf(this.start_position).compareTo(other.getPosition());
    }

    public static VariantType convertVariantType(VariantRecord.VariantType type, String alt) {
        switch (type) {
            case Insertion: {
                return VariantType.INSERTION;
            }
            case Deletion: {
                return VariantType.DELETION;
            }
            case SNP: {
                if (alt == null || alt.length() <= 0) break;
                String a = alt.substring(0, 1).toLowerCase();
                if (a.equals("a")) {
                    return VariantType.SNP_A;
                }
                if (a.equals("c")) {
                    return VariantType.SNP_C;
                }
                if (a.equals("g")) {
                    return VariantType.SNP_G;
                }
                if (!a.equals("t")) break;
                return VariantType.SNP_T;
            }
        }
        return VariantType.OTHER;
    }

    public boolean isPhased() {
        return false;
    }
}

