/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.variants;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.SelectableListView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.variants.MergedMedSavantVariantRecord;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import savant.api.adapter.BookmarkAdapter;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.adapter.VariantDataSourceAdapter;
import savant.api.data.DataFormat;
import savant.api.data.VariantRecord;
import savant.api.util.Resolution;
import savant.controller.TrackController;
import savant.exception.RenderingException;
import savant.util.DrawingInstruction;
import savant.view.tracks.Track;

public class MedSavantDataSource
implements DataSourceAdapter<VariantRecord>,
VariantDataSourceAdapter,
Listener<SelectableListView.SelectionEvent> {
    private static final Log LOG = LogFactory.getLog(MedSavantDataSource.class);
    private Set<String> chromosomes = new HashSet<String>();
    private String[] participants = new String[0];
    private static final int LIMIT = 100000;
    private List<String> restrictToTheseDNAIDs;
    List<String> dnaIds;

    public MedSavantDataSource() {
        try {
            this.updateSource();
        }
        catch (Exception ex) {
            Logger.getLogger(MedSavantDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
        FilterController.getInstance().addListener(new Listener<FilterEvent>(){

            @Override
            public void handleEvent(FilterEvent event) {
                MedSavantDataSource.this.refresh();
            }
        });
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                try {
                    MedSavantDataSource.this.updateSource();
                }
                catch (Exception ex) {
                    Logger.getLogger(MedSavantDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
                MedSavantDataSource.this.refresh();
            }
        });
    }

    private void updateSource() throws SQLException, RemoteException, InterruptedException {
        List<String> dnaIds;
        List<String> chroms;
        try {
            chroms = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentVariantTableName(), BasicVariantColumns.CHROM.getColumnName(), false);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.chromosomes.clear();
        for (String c : chroms) {
            this.chromosomes.add(c);
        }
        try {
            dnaIds = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentVariantTableName(), BasicVariantColumns.DNA_ID.getColumnName(), false);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.participants = new String[dnaIds.size()];
        for (int i = 0; i < dnaIds.size(); ++i) {
            this.participants[i] = dnaIds.get(i);
        }
    }

    public void refresh() {
        Track t = this.getTrack();
        if (t != null) {
            t.getFrame().forceRedraw();
        }
    }

    public Set<String> getReferenceNames() {
        return this.chromosomes;
    }

    public List<VariantRecord> getRecords(String ref, RangeAdapter range, Resolution resolution, RecordFilterAdapter<VariantRecord> filter) throws IOException, InterruptedException {
        if (this.dnaIds == null) {
            try {
                this.dnaIds = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentVariantTableName(), BasicVariantColumns.DNA_ID.getColumnName(), false);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            Condition[][] conditions;
            String savantChrom;
            Track track = this.getTrack();
            if (track != null) {
                track.getFrame().setCloseable(false);
            }
            String chrom = savantChrom = savant.util.MiscUtils.homogenizeSequence((String)ref);
            for (String c : this.chromosomes) {
                if (!savant.util.MiscUtils.homogenizeSequence((String)c).equals(savantChrom)) continue;
                chrom = c;
            }
            Condition[][] filterConditions = FilterController.getInstance().getAllFilterConditions();
            TableSchema table = ProjectController.getInstance().getCurrentVariantTableSchema();
            if (this.restrictToTheseDNAIDs != null) {
                Condition[] restrictToDNAIDsCondition = new Condition[this.restrictToTheseDNAIDs.size()];
                int i = 0;
                for (String dnaID : this.restrictToTheseDNAIDs) {
                    restrictToDNAIDsCondition[i++] = BinaryCondition.equalTo(table.getDBColumn(BasicVariantColumns.DNA_ID.getColumnName()), dnaID);
                }
                Condition[][] newFilterConditions = new Condition[filterConditions.length + 1][];
                for (i = 0; i < filterConditions.length; ++i) {
                    newFilterConditions[i] = filterConditions[i];
                }
                newFilterConditions[filterConditions.length] = restrictToDNAIDsCondition;
                filterConditions = newFilterConditions;
            }
            ComboCondition rangeCondition = ComboCondition.and(BinaryCondition.equalTo(table.getDBColumn(BasicVariantColumns.CHROM.getColumnName()), chrom), MiscUtils.getIntersectCondition(range.getFrom(), range.getTo(), ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.START_POSITION), ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.END_POSITION)));
            if (filterConditions.length == 0) {
                conditions = new Condition[][]{{rangeCondition}};
            } else {
                conditions = new Condition[filterConditions.length][];
                for (int i = 0; i < filterConditions.length; ++i) {
                    conditions[i] = new Condition[2];
                    conditions[i][0] = rangeCondition;
                    conditions[i][1] = ComboCondition.and(filterConditions[i]);
                }
            }
            List<Object[]> filteredVariants = MedSavantClient.VariantManager.getVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), conditions, 0, 100000);
            HashMap<String, MergedMedSavantVariantRecord> recordMap = new HashMap<String, MergedMedSavantVariantRecord>();
            if (filteredVariants.size() == 100000) {
                Track t = this.getTrack();
                if (t != null) {
                    t.getRenderer().addInstruction(DrawingInstruction.ERROR, (Object)new RenderingException("Too many variants to display", 1));
                }
                return new ArrayList<VariantRecord>();
            }
            for (Object[] arr : filteredVariants) {
                Integer position = (Integer)arr[5];
                String refString = (String)arr[8];
                String key = position.toString() + refString;
                MergedMedSavantVariantRecord m = (MergedMedSavantVariantRecord)recordMap.get(key);
                if (m == null) {
                    m = new MergedMedSavantVariantRecord(arr, this.participants.length);
                    recordMap.put(key, m);
                }
                m.addRecord(arr, this.getIndexOfParticipant((String)arr[3]));
            }
            ArrayList<VariantRecord> records = new ArrayList<VariantRecord>();
            for (String key : recordMap.keySet()) {
                records.add((VariantRecord)recordMap.get(key));
            }
            return records;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public URI getURI() {
        return URI.create("meds://placeholder");
    }

    public String getName() {
        return "Filtered Variants";
    }

    public void close() {
        MedSavantFrame.getInstance().requestClose();
    }

    public DataFormat getDataFormat() {
        return DataFormat.VARIANT;
    }

    public String[] getColumnNames() {
        return new String[0];
    }

    public void loadDictionary() throws IOException {
    }

    public List<BookmarkAdapter> lookup(String key) {
        return new ArrayList<BookmarkAdapter>();
    }

    private int getIndexOfParticipant(String dnaId) {
        for (int i = 0; i < this.participants.length; ++i) {
            if (!this.participants[i].equals(dnaId)) continue;
            return i;
        }
        return -1;
    }

    public String[] getParticipants() {
        return this.participants;
    }

    private Track getTrack() {
        return TrackController.getInstance().getTrack(this.getName());
    }

    @Override
    public void handleEvent(SelectableListView.SelectionEvent event) {
        List dnaIDs = event.getSelections();
        this.setRestrictToDNAIDs(dnaIDs);
    }

    private void setRestrictToDNAIDs(List<String> dnaIDs) {
        LOG.info((Object)("Restricting genome browser to " + dnaIDs + " dna ids"));
        this.restrictToTheseDNAIDs = dnaIDs;
        this.refresh();
    }
}

