/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util.form;

import eu.hansolo.custom.SteelCheckBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.component.PlaceHolderPasswordField;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.client.view.util.form.NiceFormField;
import org.ut.biolab.medsavant.client.view.util.form.NiceFormFieldGroup;
import org.ut.biolab.medsavant.client.view.util.form.NiceFormModel;
import savant.api.util.DialogUtils;

public class NiceForm
extends JPanel
implements Listener<NiceFormModel> {
    private NiceFormModel model;
    private LinkedHashMap<NiceFormField, JComponent> map;
    private boolean showEditButton;
    private boolean isInEditMode;
    private final List<Listener<FormEvent>> listeners;
    private Font valueFont = new Font(ViewUtil.getDefaultFontFamily(), 0, 13);
    private Font keyFont = new Font(ViewUtil.getDefaultFontFamily(), 0, 11);
    private Color valueFontColor = ViewUtil.getMedSavantBlueColor();
    private Color keyFontColor = new Color(0, 0, 0);

    public void focus() {
        try {
            NiceFormField field = this.map.keySet().iterator().next();
            JComponent c = this.map.get(field);
            c.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEditModeOn(boolean b) {
        this.isInEditMode = b;
        this.refresh();
    }

    public boolean isEditModeOn() {
        return this.isInEditMode;
    }

    public NiceForm(NiceFormModel model) {
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setModel(model);
        this.listeners = new ArrayList<Listener<FormEvent>>();
    }

    private void setModel(NiceFormModel model) {
        this.model = model;
        this.model.setListener(this);
        this.refresh();
    }

    @Override
    public void handleEvent(NiceFormModel event) {
        this.refresh();
    }

    public void addListener(Listener<FormEvent> listener) {
        this.listeners.add(listener);
    }

    public void refresh() {
        this.removeAll();
        this.setLayout((LayoutManager)new MigLayout("insets 0, gapx 5, gapy 5"));
        if (this.showEditButton) {
            final SteelCheckBox cb = ViewUtil.getSwitchCheckBox();
            cb.setSelected(!this.isInEditMode);
            final NiceForm instance = this;
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean isEditing = !cb.isSelected();
                    instance.setEditModeOn(!cb.isSelected());
                    for (Listener listener : NiceForm.this.listeners) {
                        listener.handleEvent(isEditing ? FormEvent.DID_LOCK_FOR_EDITING : FormEvent.DID_LOCK_FOR_EDITING);
                    }
                }
            });
            this.add((Component)cb, "wrap");
        }
        this.map = new LinkedHashMap();
        int count = 0;
        for (NiceFormFieldGroup g : this.model.getGroups()) {
            this.appendGroup(g);
            if (++count == this.model.getGroups().size()) continue;
            this.add(Box.createVerticalStrut(10), "wrap");
        }
        this.updateUI();
        this.invalidate();
    }

    private void appendGroup(NiceFormFieldGroup group) {
        if (group.displayHeading()) {
            this.add((Component)ViewUtil.getEmphasizedLabel(group.getName().toUpperCase()), "wrap, span");
        }
        for (NiceFormField field : group.getFields()) {
            boolean addLabel = true;
            JComponent c = null;
            int stringFieldWidth = 16;
            int intFieldWidth = 5;
            switch (field.getType()) {
                case NUMBER: {
                    if (this.isInEditMode) {
                        JTextField f0 = new JTextField(field.getName());
                        if (field.getValue() != null) {
                            f0.setText(field.getValue().toString());
                        }
                        f0.setColumns(intFieldWidth);
                        c = f0;
                        break;
                    }
                    if (field.getValue() == null) break;
                    c = new JLabel(field.getValue().toString());
                    break;
                }
                case STRING: 
                case EMAIL: {
                    if (this.isInEditMode) {
                        JTextField f1 = new JTextField(field.getName(), stringFieldWidth);
                        if (field.getValue() != null) {
                            f1.setText(field.getValue().toString());
                        }
                        c = f1;
                        break;
                    }
                    if (field.getValue() == null) break;
                    c = new JLabel(field.getValue().toString());
                    break;
                }
                case PASSWORD: {
                    if (this.isInEditMode) {
                        PlaceHolderPasswordField f2 = new PlaceHolderPasswordField("", stringFieldWidth);
                        f2.setPlaceholder("");
                        if (field.getValue() != null) {
                            f2.setText(field.getValue().toString());
                        }
                        c = f2;
                        break;
                    }
                    if (field.getValue() == null) break;
                    c = new JLabel(ViewUtil.bulletStringOfLength(field.getValue().toString().length()));
                    break;
                }
                case BOOLEAN: {
                    addLabel = false;
                    JCheckBox cb = new JCheckBox(field.getName());
                    if (field.getValue() != null) {
                        cb.setSelected((Boolean)field.getValue());
                    }
                    cb.setEnabled(this.isInEditMode);
                    c = cb;
                }
            }
            if (addLabel) {
                JLabel label = new JLabel(field.getName().toUpperCase());
                label.setFont(this.keyFont);
                label.setForeground(this.keyFontColor);
                this.add(label);
            } else {
                this.add(Box.createHorizontalStrut(1));
            }
            if (c == null) continue;
            c.setFont(this.valueFont);
            c.setForeground(this.valueFontColor);
            this.add((Component)c, "wrap");
            this.map.put(field, c);
        }
    }

    public boolean isFieldSet(NiceFormField field) {
        switch (field.getType()) {
            case NUMBER: 
            case STRING: 
            case PASSWORD: {
                return !((JTextField)this.map.get(field)).getText().isEmpty();
            }
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    public String getValueForStringField(NiceFormField field) {
        if (field.getType() == FieldType.STRING || field.getType() == FieldType.EMAIL || field.getType() == FieldType.PASSWORD) {
            return ((JTextField)this.map.get(field)).getText();
        }
        throw new IllegalArgumentException(field.getName() + " does not have a String value");
    }

    public int getValueForIntegerField(NiceFormField field) {
        if (field.getType() == FieldType.NUMBER) {
            try {
                return Integer.parseInt(((JTextField)this.map.get(field)).getText());
            }
            catch (Exception e) {
                return -1;
            }
        }
        throw new IllegalArgumentException(field.getName() + " does not have a Integer value");
    }

    public boolean getValueForBooleanField(NiceFormField field) {
        if (field.getType() == FieldType.BOOLEAN) {
            return ((JCheckBox)this.map.get(field)).isSelected();
        }
        throw new IllegalArgumentException(field.getName() + " does not have a Boolean value");
    }

    public boolean validateForm() {
        for (NiceFormFieldGroup group : this.model.getGroups()) {
            for (NiceFormField field : group.getFields()) {
                boolean success = this.validateField(field);
                if (success) continue;
                DialogUtils.displayError((String)("Invalid value for " + field.getName()));
                this.map.get(field).requestFocus();
                return false;
            }
        }
        return true;
    }

    public void setShowEditButton(boolean b) {
        this.showEditButton = b;
        this.refresh();
    }

    public boolean isEditable() {
        return this.showEditButton;
    }

    private boolean validateField(NiceFormField field) {
        try {
            if (!field.isRequired() && !this.isFieldSet(field)) {
                return true;
            }
            switch (field.getType()) {
                case BOOLEAN: {
                    this.getValueForBooleanField(field);
                    break;
                }
                case NUMBER: {
                    int i = this.getValueForIntegerField(field);
                    if (i >= 0) break;
                    return false;
                }
                case STRING: 
                case EMAIL: 
                case PASSWORD: {
                    String s = this.getValueForStringField(field);
                    if (!s.isEmpty()) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        f.setBackground(Color.white);
        f.setLayout((LayoutManager)new MigLayout("wrap"));
        NiceFormFieldGroup g = new NiceFormFieldGroup("Heading", true);
        g.addField(new NiceFormField(true, "field", FieldType.STRING, "Hello"));
        NiceFormModel m = new NiceFormModel();
        m.addGroup(g);
        NiceForm form = new NiceForm(m);
        f.add(form);
        f.pack();
        f.setVisible(true);
    }

    public static enum FieldType {
        STRING,
        EMAIL,
        NUMBER,
        PASSWORD,
        BOOLEAN;

    }

    public static enum FormEvent {
        DID_UNLOCK_FOR_EDITING,
        DID_LOCK_FOR_EDITING;

    }
}

