/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;

public class PathField
extends JPanel {
    JTextField field = new JTextField();
    JButton button = new JButton("...");
    boolean saving;
    boolean directoriesOnly;

    public PathField(int chooserType) {
        this(chooserType, false);
    }

    public PathField(int type, boolean directoriesOnly) {
        this.saving = type == 1;
        this.directoriesOnly = directoriesOnly;
        this.field.setMaximumSize(new Dimension(9999, 22));
        if (this.saving) {
            this.field.setToolTipText("Path to output file");
            this.button.setToolTipText("Set output file");
        } else {
            this.field.setToolTipText("Path to input file");
            this.button.setToolTipText("Choose input file");
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.field);
        this.add(this.button);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = PathField.this.saving ? DialogUtils.chooseFileForSave(PathField.this.button.getToolTipText(), PathField.this.field.getText()) : DialogUtils.chooseFileForOpen(PathField.this.button.getToolTipText(), null, null);
                if (f != null) {
                    PathField.this.setPath(f.getAbsolutePath());
                }
            }
        });
        this.setOpaque(false);
    }

    public File getFile() {
        return new File(this.field.getText());
    }

    public String getPath() {
        return this.field.getText();
    }

    public void setPath(String s) {
        this.field.setText(s);
    }

    public JTextField getPathArea() {
        return this.field;
    }
}

