/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class FixedLengthTextFilter
extends DocumentFilter {
    private int maxLength;

    public FixedLengthTextFilter(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass filtby, int ofs, String text, AttributeSet attrSet) throws BadLocationException {
        if (filtby.getDocument().getLength() + text.length() <= this.maxLength) {
            filtby.insertString(ofs, text, attrSet);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass filtby, int ofs, int length, String text, AttributeSet attr) throws BadLocationException {
        if (filtby.getDocument().getLength() + text.length() - length <= this.maxLength) {
            filtby.replace(ofs, length, text, attr);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

