/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import com.jidesoft.dialog.JideOptionPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.dialog.BugReportDialog;
import org.ut.biolab.medsavant.shared.util.ExtensionFileFilter;

public class DialogUtils {
    public static final int YES = 0;
    public static final int OK = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;

    public static int askOKCancel(String title, String prompt) {
        return JOptionPane.showConfirmDialog(DialogUtils.getFrontWindow(), prompt, title, 2, 3);
    }

    public static int askYesNo(String title, String prompt) {
        return JOptionPane.showConfirmDialog(DialogUtils.getFrontWindow(), prompt, title, 0, 3);
    }

    public static int askYesNo(String title, String prompt, Object ... args) {
        return JOptionPane.showConfirmDialog(DialogUtils.getFrontWindow(), String.format(prompt, args), title, 0, 3);
    }

    public static int askYesNoCancel(String title, String prompt) {
        return JOptionPane.showConfirmDialog(DialogUtils.getFrontWindow(), prompt, title, 1, 3);
    }

    public static void displayError(String title, String message) {
        JOptionPane.showMessageDialog(DialogUtils.getFrontWindow(), message, title, 0);
    }

    public static void displayMessage(String title, String message) {
        JOptionPane.showMessageDialog(DialogUtils.getFrontWindow(), message, title, -1);
    }

    public static String displayInputMessage(String title, String message, String defaultInput) {
        String result = JOptionPane.showInputDialog(DialogUtils.getFrontWindow(), message, title, 3);
        if (result != null && result.length() > 0) {
            return result;
        }
        return null;
    }

    public static void displayException(final String title, final String message, final Throwable t) {
        ClientMiscUtils.invokeLaterIfNecessary(new Runnable(){

            @Override
            public void run() {
                String msg = message;
                if (t.getCause() != null) {
                    msg = msg + "\r\nCause: " + ClientMiscUtils.getMessage(t.getCause()) + ".";
                }
                JideOptionPane optionPane = new JideOptionPane((Object)msg, 0, 3);
                optionPane.setTitle((Object)title);
                optionPane.setOptions((Object[])new String[0]);
                JButton cancelButton = new JButton("Cancel");
                ((JComponent)optionPane.getComponent(optionPane.getComponentCount() - 1)).add(cancelButton);
                JButton reportButton = new JButton("Report Issue");
                ((JComponent)optionPane.getComponent(optionPane.getComponentCount() - 1)).add(reportButton);
                final JDialog dialog = optionPane.createDialog((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), title);
                cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dialog.setVisible(false);
                    }
                });
                reportButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        dialog.dispose();
                        new BugReportDialog((Frame)MedSavantFrame.getInstance(), t).setVisible(true);
                    }
                });
                dialog.setResizable(true);
                String details = t.getMessage() + "\r\n" + ClientMiscUtils.getStackTrace(t);
                optionPane.setDetails((Object)details);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }

    public static void displayMessage(String message) {
        DialogUtils.displayMessage("MedSavant", message);
    }

    public static File chooseFileForOpen(String title, FileFilter filter, File initialDir) {
        if (ClientMiscUtils.MAC) {
            FileDialog fd = DialogUtils.getFileDialog(title, 0);
            if (filter != null) {
                fd.setFilenameFilter(new FilenameFilterAdapter(filter));
            }
            if (initialDir != null) {
                fd.setDirectory(initialDir.getAbsolutePath());
            }
            fd.setVisible(true);
            fd.setAlwaysOnTop(true);
            String selectedFileName = fd.getFile();
            if (selectedFileName != null) {
                return new File(fd.getDirectory(), selectedFileName);
            }
        } else {
            int result;
            JFileChooser fd = new JFileChooser();
            fd.setDialogTitle(title);
            fd.setDialogType(0);
            if (filter != null) {
                fd.setFileFilter(filter);
            }
            if (initialDir != null) {
                fd.setCurrentDirectory(initialDir);
            }
            if ((result = fd.showOpenDialog(DialogUtils.getFrontWindow())) == 0) {
                return fd.getSelectedFile();
            }
        }
        return null;
    }

    public static File[] chooseFilesForOpen(String title, FileFilter filter, File initialDir) {
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle(title);
        fd.setSelectedFile(initialDir);
        fd.setDialogType(0);
        if (filter != null) {
            fd.setFileFilter(filter);
        }
        fd.setMultiSelectionEnabled(true);
        int result = fd.showOpenDialog(null);
        if (result == 0) {
            return fd.getSelectedFiles();
        }
        return new File[0];
    }

    public static File chooseFileForSave(String title, String defaultName) {
        FileDialog fd = DialogUtils.getFileDialog(title, 1);
        fd.setFile(defaultName);
        fd.setAlwaysOnTop(true);
        fd.setLocationRelativeTo(null);
        fd.setVisible(true);
        String selectedFile = fd.getFile();
        if (selectedFile != null) {
            return new File(fd.getDirectory(), selectedFile);
        }
        return null;
    }

    public static File chooseFileForSave(String title, String defaultName, ExtensionFileFilter[] filters, File initialDir) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        chooser.setSelectedFile(new File(initialDir, defaultName));
        if (initialDir != null) {
            chooser.setSelectedFile(initialDir);
        }
        chooser.setDialogType(1);
        if (filters != null) {
            for (ExtensionFileFilter filter : filters) {
                chooser.addChoosableFileFilter(filter);
            }
            chooser.setFileFilter(filters[0]);
        }
        chooser.setMultiSelectionEnabled(false);
        int result = chooser.showSaveDialog(null);
        if (result == 0) {
            File f = chooser.getSelectedFile();
            if (f == null) {
                return null;
            }
            String selectedFile = f.getAbsolutePath();
            if (chooser.getFileFilter() != null && chooser.getFileFilter() instanceof ExtensionFileFilter) {
                selectedFile = ((ExtensionFileFilter)chooser.getFileFilter()).forceExtension(f);
            }
            return new File(selectedFile);
        }
        return null;
    }

    public static void displayError(String message) {
        DialogUtils.displayError("MedSavant Error", message);
    }

    public static boolean confirmChangeReference(boolean isChangingProject) {
        int result = JOptionPane.showConfirmDialog(DialogUtils.getFrontWindow(), "<HTML>Changing the " + (isChangingProject ? "project" : "reference") + " will remove current filters.<BR>Are you sure you want to do this?</HTML>", "Confirm", 0, 2);
        return result == 0;
    }

    public static void displayErrorMessage(String msg, Throwable t) {
        JOptionPane.showMessageDialog(DialogUtils.getFrontWindow(), msg, "Error", 0);
    }

    public static Window getFrontWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
    }

    private static FileDialog getFileDialog(String title, int type) {
        Window w = DialogUtils.getFrontWindow();
        if (w instanceof Frame) {
            return new FileDialog((Frame)w, title, type);
        }
        return new FileDialog((Dialog)w, title, type);
    }

    static class FilenameFilterAdapter
    implements FilenameFilter {
        FileFilter filter;

        FilenameFilterAdapter(FileFilter f) {
            this.filter = f;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.filter.accept(new File(dir, name));
        }
    }
}

