/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.login;

import java.net.NoRouteToHostException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.concurrent.Semaphore;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.controller.SettingsController;
import org.ut.biolab.medsavant.client.project.ProjectChooser;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.project.ProjectWizard;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.Controller;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.login.LoginEvent;
import org.ut.biolab.medsavant.client.view.login.MedSavantServerInfo;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.UserLevel;
import org.ut.biolab.medsavant.shared.util.VersionSettings;
import org.ut.biolab.medsavant.shared.util.WebResources;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;

public class LoginController
extends Controller<LoginEvent> {
    private static final Log LOG = LogFactory.getLog(LoginController.class);
    private static final Object EVENT_LOCK = new Object();
    private static LoginController instance;
    private String userName;
    private String password;
    private UserLevel level;
    private boolean loggedIn = false;
    private static String sessionId;
    private String dbname;
    private String serverAddress;
    private Semaphore semLogin = new Semaphore(1, true);
    private MedSavantWorker<Void> currentLoginThread;

    public static String getSessionID() {
        return sessionId;
    }

    public static LoginController getInstance() {
        if (instance == null) {
            instance = new LoginController();
        }
        return instance;
    }

    private synchronized void setLoggedIn(final boolean loggedIn) {
        try {
            AnalyticsAgent.log((NameValuePair)new NameValuePair("login-event", loggedIn ? "LoggedIn" : "LoggedOut"));
        }
        catch (Exception e) {
            // empty catch block
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = EVENT_LOCK;
                synchronized (object) {
                    LoginController.this.loggedIn = loggedIn;
                    if (loggedIn) {
                        LoginController.this.fireEvent(new LoginEvent(LoginEvent.Type.LOGGED_IN));
                    } else {
                        LoginController.this.unregister();
                        LoginController.this.fireEvent(new LoginEvent(LoginEvent.Type.LOGGED_OUT));
                    }
                    if (!loggedIn && !SettingsController.getInstance().getRememberPassword()) {
                        LoginController.this.password = "";
                    }
                }
            }
        };
        t.start();
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public UserLevel getUserLevel() {
        return this.level;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    private void finishLogin(String un, String pw) {
        this.level = UserLevel.NONE;
        try {
            LOG.info((Object)"Starting session...");
            sessionId = MedSavantClient.SessionManager.registerNewSession(un, pw, this.dbname);
            this.level = this.userName.equals("root") ? UserLevel.ADMIN : MedSavantClient.UserManager.getUserLevel(sessionId, this.userName);
        }
        catch (Exception ex) {
            this.fireEvent(new LoginEvent(ex));
            return;
        }
        SettingsController settings = SettingsController.getInstance();
        settings.setUsername(un);
        if (settings.getRememberPassword()) {
            settings.setPassword(pw);
        } else {
            settings.setPassword("");
        }
        try {
            MedSavantClient.SessionManager.testConnection(sessionId);
        }
        catch (Exception ex) {
            this.fireEvent(new LoginEvent(ex));
            return;
        }
        try {
            String clientVersion = VersionSettings.getVersionString();
            String serverVersion = MedSavantClient.SettingsManager.getServerVersion();
            if (!VersionSettings.isClientCompatibleWithServer(clientVersion, serverVersion)) {
                LoginEvent e = new LoginEvent(new Exception("<html>Your client version (" + clientVersion + ") is not compatible with the server (" + serverVersion + ").<br>Visit " + WebResources.WEB_URL + " to get the correct version.</html>"));
                this.fireEvent(e);
                return;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error comparing versions.", (Throwable)ex);
            ex.printStackTrace();
            DialogUtils.displayMessage("Problem Comparing Versions", "<html>We could not determine compatibility between MedSavant and your database.<br>Please ensure that your versions are compatible before continuing.</html>");
        }
        try {
            LOG.info((Object)"Setting up project");
            if (this.setProject()) {
                LOG.info((Object)"Finalizing login");
                this.setLoggedIn(true);
            } else {
                this.fireEvent(new LoginEvent(LoginEvent.Type.LOGIN_CANCELLED));
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error signing in: %s", ex);
            this.fireEvent(new LoginEvent(ex));
        }
    }

    public void cancelCurrentLoginAttempt() {
        if (this.currentLoginThread != null) {
            this.currentLoginThread.cancel(true);
            this.fireEvent(new LoginEvent(LoginEvent.Type.LOGIN_CANCELLED));
            this.currentLoginThread = null;
        }
    }

    public synchronized void login(MedSavantServerInfo server) {
        this.login(server.getUsername(), server.getPassword(), server.getDatabase(), server.getHost(), server.getPort() + "");
    }

    public synchronized void login(final String un, final String pw, final String dbname, final String serverAddress, final String serverPort) {
        try {
            this.cancelCurrentLoginAttempt();
            LOG.info((Object)"Creating login worker");
            this.currentLoginThread = new MedSavantWorker<Void>("Login"){

                @Override
                protected Void doInBackground() {
                    block2: {
                        try {
                            LOG.info((Object)"Initializing registry");
                            MedSavantClient.initializeRegistry(serverAddress, serverPort);
                        }
                        catch (Exception ex) {
                            if (this.isCancelled()) break block2;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LoginController.this.fireEvent(new LoginEvent(new NoRouteToHostException("Can't connect to " + serverAddress + ": " + serverPort)));
                                }
                            });
                            LoginController.this.cancelCurrentLoginAttempt();
                        }
                    }
                    return null;
                }

                @Override
                protected void showSuccess(Void result) {
                    if (this.isCancelled()) {
                        LOG.info((Object)"Signed in, but cancelled");
                        return;
                    }
                    try {
                        LoginController.this.semLogin.acquire();
                        LoginController.getInstance().serverAddress = serverAddress;
                        LoginController.getInstance().dbname = dbname;
                        LoginController.this.userName = un;
                        LoginController.this.password = pw;
                        LoginController.this.finishLogin(un, pw);
                        LoginController.this.semLogin.release();
                    }
                    catch (Exception ex) {
                        LOG.info((Object)"Aborted login...");
                    }
                }
            };
            this.currentLoginThread.execute();
            if (Thread.interrupted()) {
                LOG.info((Object)"Aborted login...");
                return;
            }
        }
        catch (Exception ex) {
            this.fireEvent(new LoginEvent(ex));
            return;
        }
    }

    public void logout() {
        try {
            if (this.isLoggedIn()) {
                LOG.info((Object)"Logging out...");
                this.setLoggedIn(false);
                AnalyticsAgent.onEndSession((boolean)true);
                this.unregister();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregister() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    MedSavantClient.SessionManager.unregisterSession(sessionId);
                }
                catch (RemoteException ex) {
                    LOG.info((Object)("Error while logging out: " + ClientMiscUtils.getMessage(ex)));
                }
                catch (Exception ex) {
                    LOG.info((Object)("Error while logging out: " + ClientMiscUtils.getMessage(ex)));
                }
            }
        };
        new Thread(r).start();
    }

    private boolean setProject() throws SQLException, RemoteException {
        ProjectController pc = ProjectController.getInstance();
        String[] projNames = pc.getProjectNames();
        String proj = null;
        if (projNames.length == 0) {
            if (this.level == UserLevel.ADMIN) {
                DialogUtils.displayMessage("Welcome to MedSavant", "To begin using MedSavant, you will need to create a project.");
                new ProjectWizard().setVisible(true);
                projNames = pc.getProjectNames();
                if (projNames.length > 0) {
                    proj = projNames[0];
                }
            } else {
                DialogUtils.displayMessage("Welcome to MedSavant", "No projects have been started. Please contact your administrator.");
            }
        } else if (projNames.length == 1) {
            proj = projNames[0];
        } else {
            ProjectChooser d = new ProjectChooser(projNames);
            d.setVisible(true);
            proj = d.getSelected();
        }
        if (proj != null) {
            pc.setProject(proj);
            pc.setDefaultReference();
        }
        return proj != null;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getDatabaseName() {
        return this.dbname;
    }
}

