/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.list;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedListModel;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.list.ListView;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.client.view.util.list.NiceListColorScheme;

public class SplitScreenView
extends JPanel {
    private final DetailedView detailedView;
    private final ListView listView;

    public SplitScreenView(DetailedListModel model, DetailedView view) {
        this(model, view, new DetailedListEditor());
    }

    public SplitScreenView(DetailedListModel model, DetailedView view, DetailedListEditor editor) {
        this.detailedView = view;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.listView = new ListView(view.getPageName(), model, view, editor);
        this.detailedView.setSplitScreenParent(this);
        JPanel listViewContainer = ViewUtil.getClearPanel();
        listViewContainer.setLayout(new BorderLayout());
        listViewContainer.setBorder(ViewUtil.getRightLineBorder());
        listViewContainer.add((Component)this.listView, "Center");
        JSplitPane p = new JSplitPane(1, listViewContainer, this.detailedView);
        p.setBorder(BorderFactory.createEmptyBorder());
        p.setDividerSize(0);
        p.setDividerLocation(230);
        this.add((Component)p, "Center");
        this.listView.getControlBar().installDraggableWidgetOnSplitPane(p);
    }

    public void refresh() {
        this.listView.refreshList();
    }

    public Object[][] getList() {
        return this.listView.data;
    }

    public void setSearchBarEnabled(boolean b) {
        this.listView.setSearchBarEnabled(b);
    }

    public void selectItemWithKey(String key) {
        this.listView.selectItemWithKey(key);
    }

    public void selectItemAtIndex(int i) {
        this.listView.selectItemAtIndex(i);
    }

    public void setListColorScheme(NiceListColorScheme cs) {
        this.listView.setColorScheme(cs);
    }

    public void setSelectedItemText(String text) {
        this.listView.setSelectedItemText(text);
    }
}

