/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.list;

import com.explodingpixels.macwidgets.MacIcons;
import com.explodingpixels.macwidgets.SourceListControlBar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedListModel;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.client.view.util.list.NiceList;
import org.ut.biolab.medsavant.client.view.util.list.NiceListColorScheme;
import org.ut.biolab.medsavant.client.view.util.list.NiceListItem;
import org.ut.biolab.medsavant.shared.model.ProgressStatus;

public class ListView
extends JPanel {
    private static final Log LOG = LogFactory.getLog(ListView.class);
    static final int LIMIT = 10000;
    private static final String CARD_WAIT = "wait";
    private static final String CARD_SHOW = "show";
    private static final String CARD_ERROR = "error";
    private final String pageName;
    private final DetailedListModel detailedModel;
    private final DetailedView detailedView;
    private final DetailedListEditor detailedEditor;
    Object[][] data;
    private final JPanel showCard;
    private final JLabel errorMessage;
    private NiceList list;
    private final SourceListControlBar controlBar;
    private boolean searchBarEnabled = false;
    private final WaitPanel wp;
    private NiceListColorScheme listColorScheme;
    boolean isFetching = false;
    final Object fetch = new Object();

    public ListView(String page, DetailedListModel model, DetailedView view, DetailedListEditor editor) {
        this.pageName = page;
        this.detailedModel = model;
        this.detailedView = view;
        this.detailedEditor = editor;
        this.setLayout(new CardLayout());
        this.wp = new WaitPanel("Getting list");
        this.add((Component)this.wp, CARD_WAIT);
        this.showCard = new JPanel();
        this.add((Component)this.showCard, CARD_SHOW);
        JPanel errorPanel = new JPanel();
        errorPanel.setLayout(new BorderLayout());
        this.errorMessage = new JLabel("An error occurred:");
        errorPanel.add((Component)this.errorMessage, "North");
        this.add((Component)errorPanel, CARD_ERROR);
        this.controlBar = new SourceListControlBar();
        if (this.detailedEditor.doesImplementAdding()) {
            this.controlBar.createAndAddButton((Icon)MacIcons.PLUS, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListView.this.detailedEditor.addItems();
                    if (ListView.this.detailedEditor.doesRefreshAfterAdding()) {
                        ListView.this.refreshList();
                    }
                }
            });
        }
        if (this.detailedEditor.doesImplementImporting()) {
            this.controlBar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.IMPORT), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListView.this.detailedEditor.importItems();
                    if (ListView.this.detailedEditor.doesImplementImporting()) {
                        ListView.this.refreshList();
                    }
                }
            });
        }
        if (this.detailedEditor.doesImplementExporting()) {
            this.controlBar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.EXPORT), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListView.this.detailedEditor.exportItems();
                    ListView.this.refreshList();
                }
            });
        }
        if (this.detailedEditor.doesImplementDeleting()) {
            this.controlBar.createAndAddButton((Icon)MacIcons.MINUS, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListView.this.detailedEditor.deleteItems(ListView.this.getSelectedRows());
                    if (ListView.this.detailedEditor.doesRefreshAfterDeleting()) {
                        ListView.this.refreshList();
                    }
                }
            });
        }
        if (this.detailedEditor.doesImplementEditing()) {
            this.controlBar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.GEAR), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ListView.this.getSelectedRows().size() > 0) {
                        ListView.this.detailedEditor.editItem((Object[])ListView.this.getSelectedRows().get(0));
                        if (ListView.this.detailedEditor.doesRefreshAfterEditing()) {
                            ListView.this.refreshList();
                        }
                    } else {
                        DialogUtils.displayMessage("Please choose one item to edit.");
                    }
                }
            });
        }
        if (this.detailedEditor.doesImplementLoading()) {
            this.controlBar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LOAD_ON_TOOLBAR), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListView.this.detailedEditor.loadItems(ListView.this.getSelectedRows());
                }
            });
        }
        this.showWaitCard();
        this.fetchList();
    }

    public SourceListControlBar getControlBar() {
        return this.controlBar;
    }

    private List<Object[]> getSelectedRows() {
        List<NiceListItem> items = this.list.getSelectedItems();
        ArrayList<Object[]> selectedRows = new ArrayList<Object[]>();
        for (NiceListItem item : items) {
            selectedRows.add((Object[])item.getItem());
        }
        return selectedRows;
    }

    private void showWaitCard() {
    }

    private void showShowCard() {
        ((CardLayout)this.getLayout()).show(this, CARD_SHOW);
        this.updateUI();
    }

    private void showErrorCard(String message) {
        this.errorMessage.setText(String.format("<html><font color=\"#ff0000\">An error occurred:<br><font size=\"-2\">%s</font></font></html>", message));
        ((CardLayout)this.getLayout()).show(this, CARD_ERROR);
    }

    private synchronized void setList(Object[][] list) {
        this.data = list;
        try {
            this.updateShowCard();
            this.showShowCard();
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to load list.", (Throwable)ex);
            this.showErrorCard(ClientMiscUtils.getMessage(ex));
        }
    }

    void refreshList() {
        this.showWaitCard();
        this.fetchList();
    }

    private void fetchList() {
        this.isFetching = true;
        new MedSavantWorker<Object[][]>(this.pageName){

            @Override
            protected Object[][] doInBackground() throws Exception {
                try {
                    Object[][] result = ListView.this.detailedModel.getList(10000);
                    return result;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            }

            @Override
            protected void showProgress(double ignored) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void showSuccess(Object[][] result) {
                ListView.this.setList(result);
                ListView.this.isFetching = false;
                Object object = ListView.this.fetch;
                synchronized (object) {
                    ListView.this.fetch.notifyAll();
                }
                if (result.length == 0) {
                    ListView.this.detailedView.setSelectedItem(new Object[0]);
                }
            }

            @Override
            protected ProgressStatus checkProgress() {
                return new ProgressStatus("Working", 0.5);
            }
        }.execute();
    }

    private void updateShowCard() {
        int firstVisibleColumn;
        this.showCard.removeAll();
        this.showCard.setLayout(new BorderLayout());
        String[] columnNames = this.detailedModel.getColumnNames();
        Class[] columnClasses = this.detailedModel.getColumnClasses();
        int[] columnVisibility = this.detailedModel.getHiddenColumns();
        for (firstVisibleColumn = 0; columnVisibility.length > 0 && firstVisibleColumn == columnVisibility[firstVisibleColumn]; ++firstVisibleColumn) {
        }
        HashSet<Object> selectedItems = this.list != null ? new HashSet<NiceListItem>(this.list.getSelectedItems()) : new HashSet();
        this.list = new NiceList();
        if (this.listColorScheme != null) {
            this.list.setColorScheme(this.listColorScheme);
        }
        this.list.startTransaction();
        ArrayList<Integer> selectedIndicies = new ArrayList<Integer>();
        int counter = 0;
        for (Object[] row : this.data) {
            NiceListItem nli = new NiceListItem(row[firstVisibleColumn].toString(), row);
            this.list.addItem(nli);
            if (selectedItems.contains(nli)) {
                selectedIndicies.add(counter);
            }
            ++counter;
        }
        this.list.endTransaction();
        this.wp.setBackground(this.list.getColorScheme().getBackgroundColor());
        if (this.detailedView != null) {
            this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        List selectedItems = ListView.this.getSelectedRows();
                        if (selectedItems.size() == 1) {
                            ListView.this.detailedView.setSelectedItem((Object[])selectedItems.get(0));
                        } else {
                            ListView.this.detailedView.setMultipleSelections(selectedItems);
                        }
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JPopupMenu popup;
                    if (SwingUtilities.isRightMouseButton(e) && (popup = ListView.this.detailedView.createPopup()) != null) {
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        if (selectedIndicies.isEmpty()) {
            this.list.selectItemAtIndex(0);
        } else {
            this.list.selectItemsAtIndicies(selectedIndicies);
        }
        JScrollPane jsp = ViewUtil.getClearBorderlessScrollPane(this.list);
        jsp.setHorizontalScrollBar(null);
        JPanel topPanel = new JPanel();
        topPanel.setLayout((LayoutManager)new MigLayout("wrap, fillx"));
        topPanel.add(ViewUtil.getEmphasizedLabel(this.pageName.toUpperCase()));
        topPanel.setBackground(this.list.getColorScheme().getBackgroundColor());
        if (this.searchBarEnabled) {
            topPanel.add((Component)this.list.getSearchBar(), "growx 1.0");
        }
        this.showCard.add((Component)topPanel, "North");
        this.showCard.add((Component)jsp, "Center");
        this.showCard.add((Component)this.controlBar.getComponent(), "South");
    }

    public void setSearchBarEnabled(boolean b) {
        this.searchBarEnabled = b;
    }

    void selectItemWithKey(final String key) {
        System.out.println("Selecting item with key " + key);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ListView.this.isFetching) {
                    try {
                        Object object = ListView.this.fetch;
                        synchronized (object) {
                            ListView.this.fetch.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ListView.this.list.selectItemWithKey(key);
            }
        }).start();
    }

    void selectItemAtIndex(final int i) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ListView.this.isFetching) {
                    try {
                        Object object = ListView.this.fetch;
                        synchronized (object) {
                            ListView.this.fetch.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ListView.this.list.selectItemAtIndex(i);
            }
        }).start();
    }

    public void setSelectedItemText(String text) {
        NiceListItem item = this.list.getSelectedItems().get(0);
        item.setLabel(text);
        this.list.updateUI();
    }

    void setColorScheme(NiceListColorScheme cs) {
        this.listColorScheme = cs;
        if (this.list != null) {
            this.updateShowCard();
        }
    }
}

