/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.list;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.component.StripyTable;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.util.StandardFixableWidthAppPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public abstract class DetailedTableView<T>
extends DetailedView {
    private final String[] columnNames;
    private final String multipleTitle;
    protected List<T> selected = new ArrayList<T>();
    private MedSavantWorker worker;
    private final BlockingPanel blockPanel;
    private final StandardFixableWidthAppPanel detailView;
    private JPanel tableArea;
    private final JPanel tableBlock;

    public DetailedTableView(String page, String title, String multTitle, String[] colNames) {
        super(page);
        this.multipleTitle = multTitle;
        this.columnNames = colNames;
        this.detailView = new StandardFixableWidthAppPanel(title, false);
        this.blockPanel = new BlockingPanel("No item selected", this.detailView);
        this.tableBlock = this.detailView.addBlock();
        JPanel viewContainer = (JPanel)ViewUtil.clear(this.getContentPanel());
        viewContainer.setLayout(new BorderLayout());
        viewContainer.add((Component)this.blockPanel, "Center");
    }

    @Override
    public void setSelectedItem(Object[] item) {
        if (item.length == 0) {
            this.blockPanel.block();
        } else {
            this.selected.clear();
            this.selected.add(item[0]);
            this.tableBlock.removeAll();
            this.tableBlock.setLayout(new BorderLayout());
            this.detailView.setTitle(item[0].toString());
            this.tableArea = ViewUtil.getClearPanel();
            this.tableBlock.add((Component)this.tableArea, "Center");
            if (this.worker != null) {
                this.worker.cancel(true);
            }
            this.worker = this.createWorker();
            this.worker.execute();
            this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    if (DetailedTableView.this.worker.isDone()) {
                        DetailedTableView.this.blockPanel.unblock();
                    }
                }
            });
            this.tableBlock.updateUI();
        }
    }

    @Override
    public void setMultipleSelections(List<Object[]> items) {
    }

    @Override
    public JPopupMenu createPopup() {
        return null;
    }

    public JPopupMenu createTablePopup(Object[][] selected) {
        return null;
    }

    public synchronized void setData(final Object[][] data) {
        JPanel p = ViewUtil.getClearPanel();
        p.setLayout(new BorderLayout());
        final StripyTable table = new StripyTable(data, this.columnNames);
        table.setBorder(null);
        table.setGridColor(new Color(235, 235, 235));
        table.setRowHeight(21);
        p.add((Component)table.getTableHeader(), "North");
        p.add((Component)ViewUtil.getClearBorderlessScrollPane(table), "Center");
        this.tableArea.setLayout((LayoutManager)new MigLayout("fillx, filly, insets 0"));
        this.tableArea.add((Component)p, "width 100%, height 1000");
        this.tableArea.updateUI();
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int[] selection = table.getSelectedRows();
                    Object[][] selections = new Object[selection.length][table.getSize().width];
                    for (int i = 0; i < selection.length; ++i) {
                        int j = table.convertRowIndexToModel(selection[i]);
                        selections[i] = data[j];
                    }
                    JPopupMenu m = DetailedTableView.this.createTablePopup(selections);
                    if (m != null) {
                        m.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    public abstract MedSavantWorker createWorker();
}

