/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.list;

import com.explodingpixels.macwidgets.SourceList;
import com.explodingpixels.macwidgets.SourceListColorScheme;
import com.explodingpixels.painter.GradientWithBorderPainter;
import com.explodingpixels.painter.MacWidgetsPainter;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class CustomColorScheme
implements SourceListColorScheme {
    private static final MacWidgetsPainter<Component> ACTIVE_FOCUSED_SELECTION_PAINTER = CustomColorScheme.createSourceListActiveFocusedSelectionPainter();
    private static final MacWidgetsPainter<Component> ACTIVE_UNFOCUSED_SELECTION_PAINTER = CustomColorScheme.createSourceListActiveUnfocusedSelectionPainter();
    private static final MacWidgetsPainter<Component> INACTIVE_FOCUSED_SELECTION_PAINTER = CustomColorScheme.createSourceListInactiveSelectionPainter();
    private static Color ACTIVE_BACKGROUND_COLOR = new Color(245, 245, 245);
    private static Color INACTIVE_BACKGROUND_COLOR = new Color(245, 245, 245);
    private static final Color CATEGORY_FONT_COLOR = new Color(64, 64, 64);
    private static final Color CATEGORY_FONT_SHADOW_COLOR = new Color(0, 0, 0, 0);
    private static final Color ITEM_FONT_COLOR = new Color(64, 64, 64);
    private static final Color SELECTED_ITEM_FONT_COLOR = CATEGORY_FONT_COLOR;
    private static final Color SELECTED_ITEM_FONT_SHADOW_COLOR = CATEGORY_FONT_SHADOW_COLOR;
    private static final Icon COLLAPSED_ICON = new ImageIcon(SourceList.class.getResource("/com/explodingpixels/macwidgets/images/source_list_right_arrow.png"));
    private static final Icon EXPANDED_ICON = new ImageIcon(SourceList.class.getResource("/com/explodingpixels/macwidgets/images/source_list_down_arrow.png"));

    CustomColorScheme() {
    }

    public MacWidgetsPainter<Component> getActiveFocusedSelectedItemPainter() {
        return ACTIVE_FOCUSED_SELECTION_PAINTER;
    }

    public MacWidgetsPainter<Component> getActiveUnfocusedSelectedItemPainter() {
        return ACTIVE_UNFOCUSED_SELECTION_PAINTER;
    }

    public MacWidgetsPainter<Component> getInactiveSelectedItemPainter() {
        return INACTIVE_FOCUSED_SELECTION_PAINTER;
    }

    public Color getCategoryTextColor() {
        return CATEGORY_FONT_COLOR;
    }

    public Color getCategoryTextShadowColor() {
        return CATEGORY_FONT_SHADOW_COLOR;
    }

    public Color getUnselectedItemTextColor() {
        return ITEM_FONT_COLOR;
    }

    public Color getSelectedItemTextColor() {
        return SELECTED_ITEM_FONT_COLOR;
    }

    public Color getSelectedItemFontShadowColor() {
        return SELECTED_ITEM_FONT_SHADOW_COLOR;
    }

    public Color getActiveBackgroundColor() {
        return ACTIVE_BACKGROUND_COLOR;
    }

    public Color getInactiveBackgroundColor() {
        return INACTIVE_BACKGROUND_COLOR;
    }

    public Icon getUnselectedCollapsedIcon() {
        return COLLAPSED_ICON;
    }

    public Icon getUnselectedExpandedIcon() {
        return EXPANDED_ICON;
    }

    public Icon getSelectedCollapsedIcon() {
        return COLLAPSED_ICON;
    }

    public Icon getSelectedExpandedIcon() {
        return EXPANDED_ICON;
    }

    public Color getBadgeTextColor() {
        return this.getActiveBackgroundColor();
    }

    public Color getSelectedBadgeColor() {
        return Color.gray;
    }

    public Color getActiveUnselectedBadgeColor() {
        return Color.gray;
    }

    public Color getInativeUnselectedBadgeColor() {
        return Color.gray;
    }

    private static MacWidgetsPainter<Component> createSourceListActiveFocusedSelectionPainter() {
        Color topLineColor = new Color(188, 192, 198);
        Color topColor = new Color(200, 204, 211);
        Color bottomColor = new Color(174, 179, 188);
        return new GradientWithBorderPainter(topLineColor, bottomColor, topColor, bottomColor);
    }

    private static MacWidgetsPainter<Component> createSourceListActiveUnfocusedSelectionPainter() {
        return CustomColorScheme.createSourceListInactiveSelectionPainter();
    }

    private static MacWidgetsPainter<Component> createSourceListInactiveSelectionPainter() {
        Color topLineColor = new Color(0x979797);
        Color topColor = new Color(0xB4B4B4);
        Color bottomColor = new Color(0x8A8A8A);
        return new GradientWithBorderPainter(topLineColor, bottomColor, topColor, bottomColor);
    }
}

