/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.ut.biolab.medsavant.client.filter.SearchBar;
import org.ut.biolab.medsavant.client.query.QueryViewController;
import org.ut.biolab.medsavant.client.view.component.SplitScreenPanel;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.OtherIndividualsSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.SimpleVariant;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.VariantFrequencyAggregatePane;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class OtherIndividualsVariantSubInspector
extends OtherIndividualsSubInspector {
    private static final String[] COLUMN_NAMES_IN_AGGREGATE_TABLE = new String[]{"Ref.", "Alt.", BasicVariantColumns.ZYGOSITY.getAlias()};
    private static final int MAX_POSITION_STRLENGTH_TODISPLAY = 30;
    private SimpleVariant currentVariant;

    public OtherIndividualsVariantSubInspector(SplitScreenPanel splitScreenPanel) {
        super(splitScreenPanel);
        VariantFrequencyAggregatePane ap = new VariantFrequencyAggregatePane(COLUMN_NAMES_IN_AGGREGATE_TABLE){

            @Override
            public Object[] getRow(Cohort cohort, String familyId, VariantRecord variantRecord) {
                return new Object[]{variantRecord.getRef(), variantRecord.getAlt(), variantRecord.getZygosity()};
            }

            @Override
            public String getTitle(String currentFirstColumn) {
                String position = "this position";
                if (OtherIndividualsVariantSubInspector.this.currentVariant != null) {
                    position = "Position " + NumberFormat.getNumberInstance().format(OtherIndividualsVariantSubInspector.this.currentVariant.getGenomicRegion().getStart());
                }
                if (position.length() > 30) {
                    position = "this position";
                }
                if (currentFirstColumn.equals(BasicPatientColumns.FAMILY_ID.getAlias())) {
                    return "Variants at " + position + " by Family";
                }
                return "Variants at " + position + " by Cohort";
            }

            @Override
            public void selectVariant(VariantRecord variantRecord) {
                OtherIndividualsVariantSubInspector.this.selectVariant(variantRecord);
            }
        };
        this.init(ap);
    }

    @Override
    public String getName() {
        return "Individuals with a variant at this position";
    }

    @Override
    protected JPanel getIndividualSummaryPanel(String dnaID) {
        return new VariantSummaryPanel(dnaID);
    }

    @Override
    public boolean setObject(Object obj) {
        if (obj instanceof SimpleVariant) {
            if (this.currentVariant == (SimpleVariant)obj) {
                return false;
            }
            this.currentVariant = (SimpleVariant)obj;
            return true;
        }
        return false;
    }

    @Override
    protected synchronized List<Object[]> getQueryResults() {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        List<Object[]> results = qvc.restrictToRegion(this.currentVariant.getGenomicRegion(), this.currentVariant.getAlternate(), 1000);
        return results;
    }

    private class VariantSummaryPanel
    extends JPanel {
        public VariantSummaryPanel(String dnaID) {
            this.setLayout(new BoxLayout(this, 1));
            Set variantRecords = (Set)OtherIndividualsVariantSubInspector.this.dnaIDVariantMap.get(dnaID);
            for (final VariantRecord variantRecord : variantRecords) {
                int initialIndent = this.getFontMetrics(this.getFont()).charWidth('T');
                int subsequentIndent = this.getFontMetrics(this.getFont()).stringWidth("Typ");
                this.add(this.getRow("Type: " + (Object)((Object)variantRecord.getType()), initialIndent));
                this.add(this.getRow("Zygosity: " + variantRecord.getZygosity().toString(), subsequentIndent));
                this.add(this.getRow("Ref.: " + variantRecord.getRef(), subsequentIndent));
                this.add(this.getRow("Alt.: " + variantRecord.getAlt(), subsequentIndent));
                JButton showButton = new JButton("Show");
                showButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        OtherIndividualsVariantSubInspector.this.selectVariant(variantRecord);
                    }
                });
                JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
                buttonPanel.add(Box.createHorizontalGlue());
                buttonPanel.add(showButton);
                this.add(buttonPanel);
            }
        }

        private JPanel getRow(String txt, int indent) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.setBorder(new EmptyBorder(0, indent, 0, 0));
            p.add(this.getLabel(txt));
            p.add(Box.createHorizontalGlue());
            return p;
        }

        private JPanel getRow(String lbl1, String value1, String lbl2, String value2) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(this.getLabel(lbl1));
            p.add(this.getLabel(value1));
            p.add(Box.createHorizontalGlue());
            p.add(this.getLabel(lbl2));
            p.add(this.getLabel(value2));
            return p;
        }

        private JLabel getLabel(String txt) {
            JLabel lbl = new JLabel(txt);
            lbl.setToolTipText("Foo");
            lbl.setAlignmentX(1.0f);
            lbl.setAlignmentY(1.0f);
            return lbl;
        }

        private JLabel getBoldLabel(String txt) {
            JLabel lbl = new JLabel(txt);
            lbl.setFont(lbl.getFont().deriveFont(1));
            return lbl;
        }
    }
}

