/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;

public class OntologySubInspector
extends SubInspector
implements Listener<Gene> {
    private JPanel panel;
    private JList termBox;
    private JScrollPane termScroller;
    private JLabel noTermsLabel;
    private JButton linkButton;

    @Override
    public String getName() {
        return "Ontology";
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.panel == null) {
            this.panel = ViewUtil.getClearPanel();
            this.panel.setLayout(new GridBagLayout());
            JLabel keyLabel = KeyValuePairPanel.getKeyLabel("Terms");
            this.termBox = new JList();
            this.termBox.setFixedCellHeight(15);
            this.termBox.setFixedCellWidth(10);
            this.termBox.setVisibleRowCount(12);
            this.termBox.setFont(this.termBox.getFont().deriveFont(9.0f));
            this.termBox.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent lse) {
                    OntologySubInspector.this.linkButton.setEnabled(lse.getFirstIndex() >= 0);
                }
            });
            this.termScroller = new JScrollPane(this.termBox, 20, 30);
            this.noTermsLabel = new JLabel("No matching terms.");
            this.noTermsLabel.setFont(KeyValuePairPanel.KEY_FONT);
            this.linkButton = ViewUtil.getTexturedButton("Link", IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT));
            this.linkButton.setToolTipText("Lookup ontology term");
            this.linkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    OntologyTerm ont = (OntologyTerm)OntologySubInspector.this.termBox.getSelectedValue();
                    if (ont != null) {
                        try {
                            URL url = ont.getInfoURL();
                            if (url != null) {
                                try {
                                    Desktop.getDesktop().browse(url.toURI());
                                }
                                catch (Exception ex) {
                                    ClientMiscUtils.reportError(String.format("Unable to open browser for %s: %%s", url), ex);
                                }
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        }
                        catch (MalformedURLException ex) {
                            ClientMiscUtils.reportError(String.format("Unable to get URL for %s: %%s", ont.getID()), ex);
                        }
                    }
                }
            });
            GridBagConstraints gbc = this.getContentConstraints();
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.panel.add((Component)keyLabel, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.panel.add((Component)this.noTermsLabel, gbc);
            gbc.gridy = 1;
            gbc.fill = 0;
            this.panel.add((Component)this.linkButton, gbc);
        }
        return this.panel;
    }

    @Override
    public void handleEvent(Gene g) {
        this.retrieveTerms(g);
    }

    private void retrieveTerms(final Gene g) {
        this.linkButton.setEnabled(false);
        if (g != null) {
            new MedSavantWorker<OntologyTerm[]>("SubInspector"){

                @Override
                protected void showProgress(double fraction) {
                }

                @Override
                protected void showSuccess(OntologyTerm[] result) {
                    GridBagConstraints gbc = OntologySubInspector.this.getContentConstraints();
                    if (result.length > 0) {
                        OntologySubInspector.this.termBox.setModel(new DefaultComboBoxModel<OntologyTerm>(result));
                        OntologySubInspector.this.panel.remove(OntologySubInspector.this.noTermsLabel);
                        gbc.fill = 1;
                        OntologySubInspector.this.panel.add((Component)OntologySubInspector.this.termScroller, gbc);
                    } else {
                        OntologySubInspector.this.panel.remove(OntologySubInspector.this.termBox);
                        gbc.fill = 2;
                        OntologySubInspector.this.panel.add((Component)OntologySubInspector.this.noTermsLabel, gbc);
                    }
                    OntologySubInspector.this.panel.updateUI();
                }

                @Override
                protected OntologyTerm[] doInBackground() throws Exception {
                    return MedSavantClient.OntologyManager.getTermsForGene(LoginController.getSessionID(), null, g.getName());
                }
            }.execute();
        } else {
            GridBagConstraints gbc = this.getContentConstraints();
            this.panel.remove(this.termBox);
            gbc.fill = 2;
            this.panel.add((Component)this.noTermsLabel, gbc);
        }
    }

    private GridBagConstraints getContentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.insets = new Insets(5, 5, 5, 5);
        return gbc;
    }
}

