/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class HGMDSubInspector
extends SubInspector {
    private static final String URL_CHARSET = "UTF-8";
    private final String HGMD_RSID_TEXT = "hgmd_pro_allmut, dbsnp";
    private final String HGMD_PMID_TEXT = "hgmd_pro_allmut, pmid";
    private final String HGMD_OMIM_TEXT = "hgmd_pro_allmut, omimid";
    private final String HGMD_DISEASE_TEXT = "hgmd_pro_allmut, disease";
    private final String HGMD_DESCRIPTION_TEXT = "hgmd_pro_allmut, descr";
    private final String HGMD_ACC_TEXT = "hgmd_pro_allmut, acc_num";
    private final String HGMD_COMMENTS_TEXT = "hgmd_pro_allmut, comments";
    private final String baseDBSNPUrl = "http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=";
    private final String baseOMIMUrl = "http://www.omim.org/entry/";
    private final String basePubmedUrl = "http://www.ncbi.nlm.nih.gov/pubmed/";
    private final int KEY_VALUE_PAIR_PANEL_ADDITIONAL_COLUMN_NUMBER = 4;
    private final String KEY_HGMD_RSID = "dbSNP ID";
    private final String KEY_HGMD_OMIM = "OMIM Disease ID";
    private final String KEY_HGMD_DISEASE = "Disease Name";
    private final String KEY_HGMD_ACC = "HGMD Accession";
    private final String KEY_HGMD_PMID = "Pubmed ID";
    private final String KEY_HGMD_DESCR = "Description";
    private final String KEY_HGMD_COMMENTS = "HGMD Comments";
    private Object[] currentLine;
    private KeyValuePairPanel p;
    private String rsID;
    private String omimID;
    private String pubmedID;
    private String disease;
    private String accession;
    private String comments;
    private String description;

    @Override
    public String getName() {
        return "HGMD Information";
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.p == null) {
            this.p = new KeyValuePairPanel(4);
            this.p.addKey("dbSNP ID");
            this.p.addKey("OMIM Disease ID");
            this.p.addKey("Disease Name");
            this.p.addKey("HGMD Accession");
            this.p.addKey("Pubmed ID");
            this.p.addKey("Description");
            this.p.addKey("HGMD Comments");
        }
        return this.p;
    }

    public void setVariantLine(Object[] line, List<String> header) {
        this.currentLine = line;
        this.getHGMDValues(header);
        this.p.setValue("HGMD Accession", this.accession);
        this.p.setValue("dbSNP ID", this.rsID);
        int buttonNumber = 0;
        this.p.setAdditionalColumn("dbSNP ID", buttonNumber++, KeyValuePairPanel.getCopyButton("dbSNP ID", this.p));
        this.p.setAdditionalColumn("dbSNP ID", buttonNumber++, this.getKeyValuePairPanelButton("dbSNP ID", "http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=", this.p.getValue("dbSNP ID"), true));
        this.p.setValue("Disease Name", this.disease);
        this.p.setValue("OMIM Disease ID", this.omimID);
        buttonNumber = 0;
        this.p.setAdditionalColumn("OMIM Disease ID", buttonNumber++, KeyValuePairPanel.getCopyButton("OMIM Disease ID", this.p));
        this.p.setAdditionalColumn("OMIM Disease ID", buttonNumber++, this.getKeyValuePairPanelButton("OMIM Disease ID", "http://www.omim.org/entry/", this.omimID, true));
        this.p.setValue("Pubmed ID", this.pubmedID);
        buttonNumber = 0;
        this.p.setAdditionalColumn("Pubmed ID", buttonNumber++, KeyValuePairPanel.getCopyButton("Pubmed ID", this.p));
        this.p.setAdditionalColumn("Pubmed ID", buttonNumber++, this.getKeyValuePairPanelButton("Pubmed ID", "http://www.ncbi.nlm.nih.gov/pubmed/", this.pubmedID, true));
        this.p.setValue("Description", this.description);
        this.p.setValue("HGMD Comments", this.comments);
    }

    private void getHGMDValues(List<String> header) {
        String descriptionTemp;
        String commentsTemp;
        String accessionTemp;
        String diseaseTemp;
        String pubmedIDTemp;
        Integer omimIDTemp;
        String rsIDTemp;
        this.resetHGMDFields();
        this.rsID = "";
        if (header.indexOf("hgmd_pro_allmut, dbsnp") != -1 && (rsIDTemp = (String)this.currentLine[header.indexOf("hgmd_pro_allmut, dbsnp")]) != null && !rsIDTemp.equals("\\N")) {
            this.rsID = rsIDTemp;
        }
        this.omimID = "";
        if (header.indexOf("hgmd_pro_allmut, omimid") != -1 && (omimIDTemp = (Integer)this.currentLine[header.indexOf("hgmd_pro_allmut, omimid")]) != null) {
            this.omimID = omimIDTemp.toString();
        }
        this.pubmedID = "";
        if (header.indexOf("hgmd_pro_allmut, pmid") != -1 && (pubmedIDTemp = (String)this.currentLine[header.indexOf("hgmd_pro_allmut, pmid")]) != null) {
            this.pubmedID = pubmedIDTemp;
        }
        this.disease = "";
        if (header.indexOf("hgmd_pro_allmut, disease") != -1 && (diseaseTemp = (String)this.currentLine[header.indexOf("hgmd_pro_allmut, disease")]) != null) {
            this.disease = diseaseTemp;
        }
        this.accession = "";
        if (header.indexOf("hgmd_pro_allmut, acc_num") != -1 && (accessionTemp = (String)this.currentLine[header.indexOf("hgmd_pro_allmut, acc_num")]) != null) {
            this.accession = accessionTemp;
        }
        this.comments = "";
        if (header.indexOf("hgmd_pro_allmut, comments") != -1 && (commentsTemp = (String)this.currentLine[header.indexOf("hgmd_pro_allmut, comments")]) != null) {
            this.comments = commentsTemp;
        }
        this.description = "";
        if (header.indexOf("hgmd_pro_allmut, descr") != -1 && (descriptionTemp = (String)this.currentLine[header.indexOf("hgmd_pro_allmut, descr")]) != null) {
            this.description = descriptionTemp;
        }
    }

    private void resetHGMDFields() {
        this.rsID = "";
        this.omimID = "";
        this.pubmedID = "";
        this.disease = "";
        this.accession = "";
        this.comments = "";
        this.description = "";
    }

    private Component getKeyValuePairPanelButton(String key, final String baseUrl, final String appendToUrl, final boolean doEncode) {
        JButton ncbiButton = ViewUtil.getTexturedButton("", IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT));
        ncbiButton.setToolTipText("Lookup " + key + " on the web");
        ncbiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    URL url = doEncode ? new URL(baseUrl + URLEncoder.encode(appendToUrl, HGMDSubInspector.URL_CHARSET)) : new URL(baseUrl + appendToUrl);
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Problem launching website: %s", ex);
                }
            }
        });
        return ncbiButton;
    }

    public String getRsID() {
        return this.rsID;
    }

    public String getOmimID() {
        return this.omimID;
    }

    public String getDisease() {
        return this.disease;
    }

    public String getHGMDAccession() {
        return this.accession;
    }

    public String getPubmedID() {
        return this.pubmedID;
    }

    public String getHGMDComments() {
        return this.comments;
    }

    public String getHGMDDescription() {
        return this.description;
    }
}

