/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JButton;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class EntrezButton
extends JButton {
    static String charset = "UTF-8";
    private String geneName;

    public EntrezButton(String geneName) {
        super(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT));
        this.geneName = geneName;
        ViewUtil.makeSmall(this);
        this.putClientProperty("JButton.buttonType", "textured");
        this.setVerticalTextPosition(0);
        this.setHorizontalTextPosition(2);
        this.setToolTipText("Lookup Gene on Entrez");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    URL destinationURL = EntrezButton.this.getURL();
                    Desktop.getDesktop().browse(destinationURL.toURI());
                }
                catch (Exception ex) {
                    DialogUtils.displayError("Problem launching website.");
                }
            }
        });
    }

    private URL getURL() throws MalformedURLException, UnsupportedEncodingException, IOException {
        String baseUrl2 = "http://www.ncbi.nlm.nih.gov";
        Element link = this.getParsedLink();
        if (link == null) {
            return new URL("http://www.ncbi.nlm.nih.gov/gene?term=" + URLEncoder.encode(this.geneName, charset));
        }
        String urlSuffix = link.select("a").attr("href");
        return new URL(baseUrl2 + urlSuffix);
    }

    public Element getParsedLink() throws MalformedURLException, UnsupportedEncodingException, IOException {
        String baseUrl1 = "http://www.ncbi.nlm.nih.gov/gene?term=";
        URL url = new URL(baseUrl1 + URLEncoder.encode(this.geneName, charset));
        Document doc = Jsoup.parse((URL)url, (int)20000);
        Element link = doc.select("div.rslt:has(em:contains(Homo))").first();
        return link;
    }
}

