/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.inspector.stat;

import java.util.EnumMap;
import javax.swing.JTabbedPane;
import org.ut.biolab.medsavant.client.view.genetics.inspector.Inspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticGeneInspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticVariantInspector;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class StaticInspectorPanel
extends JTabbedPane {
    public static final int INSPECTOR_WIDTH = 380;
    public static final int INSPECTOR_INNER_WIDTH = 300;
    private static StaticInspectorPanel instance;
    private EnumMap<InspectorEnum, Integer> inspectorsToTabIndexMap = new EnumMap(InspectorEnum.class);

    public static StaticInspectorPanel getInstance() {
        if (instance == null) {
            instance = new StaticInspectorPanel();
        }
        return instance;
    }

    private StaticInspectorPanel() {
        this.setTabPlacement(1);
        this.setBorder(ViewUtil.getBigBorder());
        this.setBackground(ViewUtil.getTertiaryMenuColor());
        this.addTabPanel(InspectorEnum.VARIANT, StaticVariantInspector.getInstance());
        this.addTabPanel(InspectorEnum.GENE, StaticGeneInspector.getInstance());
    }

    public void switchToGeneInspector() {
        this.switchToInspector(InspectorEnum.GENE);
    }

    public void switchToVariantInspector() {
        this.switchToInspector(InspectorEnum.VARIANT);
    }

    private void switchToInspector(InspectorEnum i) {
        this.setSelectedIndex(this.inspectorsToTabIndexMap.get((Object)i));
    }

    private void addTabPanel(InspectorEnum i, Inspector tabPanel) {
        this.inspectorsToTabIndexMap.put(i, this.getTabCount());
        this.addTab(tabPanel.getName(), null, ViewUtil.getClearBorderlessScrollPane(tabPanel.getContent()), tabPanel.getName());
    }

    private static enum InspectorEnum {
        VARIANT,
        GENE;

    }
}

