/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.inspector.stat;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.genetics.inspector.CollapsibleInspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.BasicGeneSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GeneManiaSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.OntologySubInspector;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Gene;

public class StaticGeneInspector
extends CollapsibleInspector {
    private static StaticGeneInspector instance;
    private static List<Listener<Gene>> listeners;
    boolean isShown = true;
    private static final Log LOG;
    private Gene selectedGene;

    public static StaticGeneInspector getInstance() {
        if (instance == null) {
            instance = new StaticGeneInspector();
        }
        return instance;
    }

    private StaticGeneInspector() {
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(ViewUtil.getHugeBorder());
        ViewUtil.applyVerticalBoxLayout(messagePanel);
        JLabel h1 = new JLabel("No Gene Selected");
        h1.setFont(ViewUtil.getMediumTitleFont());
        String m = "<html><div style=\"text-align: center;\">Choose one from the dropdown box in the Variant Inspector and then click the Inspect button</div></html>";
        JLabel h2 = new JLabel(m);
        h2.setPreferredSize(new Dimension(190, 300));
        h2.setMinimumSize(new Dimension(190, 300));
        h2.setBackground(Color.red);
        messagePanel.add(ViewUtil.centerHorizontally(h1));
        messagePanel.add(Box.createVerticalStrut(10));
        messagePanel.add(ViewUtil.centerHorizontally(h2));
        this.setMessage(messagePanel);
        this.addSubInspector(new BasicGeneSubInspector());
        this.addSubInspector(new OntologySubInspector());
        this.addSubInspector(new GeneManiaSubInspector());
    }

    @Override
    public String getName() {
        return "Gene Inspector";
    }

    public void setGene(Gene g) {
        if (g == null) {
            this.switchToMessage();
        } else {
            this.switchToPanes();
        }
        LOG.debug((Object)("Setting gene to " + g.getName()));
        this.selectedGene = g;
        this.geneSelectionChanged(g);
    }

    public static void addGeneSelectionChangedListener(Listener<Gene> l) {
        listeners.add(l);
    }

    public void geneSelectionChanged(Gene r) {
        if (this.isShown) {
            for (Listener<Gene> l : listeners) {
                l.handleEvent(r);
            }
        }
        this.selectedGene = r;
    }

    @Override
    protected final void addSubInspector(SubInspector panel) {
        super.addSubInspector(panel);
        listeners.add((Listener)((Object)panel));
    }

    static {
        listeners = new ArrayList<Listener<Gene>>();
        LOG = LogFactory.getLog(StaticGeneInspector.class);
    }
}

